/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.hash;

import com.github.myibu.algorithm.ByteOperator;

public class SHA256 {
    private final int[] state = new int[8];
    private static final int OUTPUT_BYTE_SIZE = 32;
    private static final int[] k = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    private void init() {
        this.state[0] = 1779033703;
        this.state[1] = -1150833019;
        this.state[2] = 1013904242;
        this.state[3] = -1521486534;
        this.state[4] = 1359893119;
        this.state[5] = -1694144372;
        this.state[6] = 528734635;
        this.state[7] = 1541459225;
    }

    private void update(byte[] data, int datalen) {
        data = (data = ByteOperator.appendByte(data, ByteOperator.intToOneByte(Integer.MIN_VALUE))).length % 64 < 56 ? ByteOperator.appendBytes(data, new byte[56 - data.length % 64]) : ByteOperator.appendBytes(data, new byte[120 - data.length % 64]);
        data = ByteOperator.appendBytes(data, ByteOperator.intTo8Bytes(datalen * 8));
        for (int i = 0; i < data.length / 64; ++i) {
            byte[] block = new byte[64];
            System.arraycopy(data, i * 64, block, 0, 64);
            this.transform(block);
        }
    }

    private void transform(byte[] data) {
        int[] m = new int[64];
        int i = 0;
        int j = 0;
        while (i < 16) {
            m[i] = ByteOperator.byteArrayToInt(data, j);
            ++i;
            j += 4;
        }
        while (i < 64) {
            m[i] = this.sig1(m[i - 2]) + m[i - 7] + this.sig0(m[i - 15]) + m[i - 16];
            ++i;
        }
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int e = this.state[4];
        int f = this.state[5];
        int g = this.state[6];
        int h = this.state[7];
        for (i = 0; i < 64; ++i) {
            int t1 = (int)((long)(h + this.ep1(e) + this.ch(e, f, g) + k[i]) + ByteOperator.unsignedInt(m[i]));
            int t2 = this.ep0(a) + this.maj(a, b, c);
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        this.state[0] = this.state[0] + a;
        this.state[1] = this.state[1] + b;
        this.state[2] = this.state[2] + c;
        this.state[3] = this.state[3] + d;
        this.state[4] = this.state[4] + e;
        this.state[5] = this.state[5] + f;
        this.state[6] = this.state[6] + g;
        this.state[7] = this.state[7] + h;
    }

    private byte[] doFinal() {
        byte[] hash = new byte[32];
        for (int i = 0; i < 32; i += 4) {
            int state = this.state[i / 4];
            hash[i] = (byte)((state & 0xFF000000) >>> 24 & 0xFF);
            hash[i + 1] = (byte)((state & 0xFF0000) >>> 16 & 0xFF);
            hash[i + 2] = (byte)((state & 0xFF00) >>> 8 & 0xFF);
            hash[i + 3] = (byte)(state & 0xFF & 0xFF);
        }
        return hash;
    }

    private int rotateRight(int a, int b) {
        return a >>> b | a << 32 - b;
    }

    private int ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private int maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private int ep0(int x) {
        return this.rotateRight(x, 2) ^ this.rotateRight(x, 13) ^ this.rotateRight(x, 22);
    }

    private int ep1(int x) {
        return this.rotateRight(x, 6) ^ this.rotateRight(x, 11) ^ this.rotateRight(x, 25);
    }

    private int sig0(int x) {
        return this.rotateRight(x, 7) ^ this.rotateRight(x, 18) ^ x >>> 3;
    }

    private int sig1(int x) {
        return this.rotateRight(x, 17) ^ this.rotateRight(x, 19) ^ x >>> 10;
    }

    public byte[] encode(byte[] input) {
        this.init();
        this.update(input, input.length);
        return this.doFinal();
    }
}

