/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.data;

import com.github.myibu.algorithm.data.Bit;

public class Bits {
    public static final int BYTE_SIZE = 8;
    public static final int SHORT_SIZE = 16;
    public static final int INT_SIZE = 32;
    public static final int LONG_SIZE = 64;
    private static final int INITIAL_SIZE = 16;
    private Bit[] table = new Bit[16];
    private int size = 16;
    private int used = 0;

    Bits() {
    }

    public static Bits inverse(Bits x) {
        Bits bits = new Bits();
        bits.expand(x.used);
        for (int i = 0; i < x.used; ++i) {
            bits.table[i] = x.table[i] == Bit.ZERO ? Bit.ONE : Bit.ZERO;
        }
        bits.used += x.used;
        return bits;
    }

    public static Bits and(Bits x, Bits y) {
        Bits y1;
        Bits x1;
        Bits bits = new Bits();
        if (x.used > y.used) {
            x1 = x;
            y1 = Bits.ofZero(y.used - x.used).append(y);
        } else if (x.used < y.used) {
            x1 = Bits.ofZero(x.used - y.used).append(x);
            y1 = y;
        } else {
            x1 = x;
            y1 = y;
        }
        int newLen = x1.used;
        bits.expand(newLen);
        for (int i = 0; i < x1.used; ++i) {
            bits.table[i] = x1.table[i] == Bit.ZERO || y1.table[i] == Bit.ZERO ? Bit.ZERO : Bit.ONE;
        }
        bits.used += newLen;
        return bits;
    }

    public static Bits or(Bits x, Bits y) {
        Bits y1;
        Bits x1;
        Bits bits = new Bits();
        if (x.used > y.used) {
            x1 = x;
            y1 = Bits.ofZero(y.used - x.used).append(y);
        } else if (x.used < y.used) {
            x1 = Bits.ofZero(x.used - y.used).append(x);
            y1 = y;
        } else {
            x1 = x;
            y1 = y;
        }
        int newLen = x1.used;
        bits.expand(newLen);
        for (int i = 0; i < x1.used; ++i) {
            bits.table[i] = x1.table[i] == Bit.ONE || y1.table[i] == Bit.ONE ? Bit.ONE : Bit.ZERO;
        }
        bits.used += newLen;
        return bits;
    }

    public static Bits xor(Bits x, Bits y) {
        Bits y1;
        Bits x1;
        Bits bits = new Bits();
        if (x.used > y.used) {
            x1 = x;
            y1 = Bits.ofZero(y.used - x.used).append(y);
        } else if (x.used < y.used) {
            x1 = Bits.ofZero(x.used - y.used).append(x);
            y1 = y;
        } else {
            x1 = x;
            y1 = y;
        }
        int newLen = x1.used;
        bits.expand(newLen);
        for (int i = 0; i < x1.used; ++i) {
            bits.table[i] = x1.table[i] == y1.table[i] ? Bit.ZERO : Bit.ONE;
        }
        bits.used += newLen;
        return bits;
    }

    public Bits lShift(int offset) {
        if (offset >= this.used) {
            return Bits.ofZero(this.used);
        }
        return this.subBits(offset, this.used).append(Bits.ofZero(offset));
    }

    public Bits lShift(Bits offset) {
        return this.lShift(offset.intLength());
    }

    public Bits rShift(int offset) {
        if (offset >= this.used) {
            return Bits.ofZero(this.used);
        }
        boolean isPositive = true;
        if (this.used > 0 && this.table[0] == Bit.ONE) {
            isPositive = false;
        }
        Bits prefix = isPositive ? Bits.ofZero(offset) : Bits.ofOne(offset);
        return prefix.append(this.subBits(0, this.used - offset));
    }

    public Bits rShift(Bits offset) {
        return this.rShift(offset.intLength());
    }

    public Bits rrShift(int offset) {
        if (offset >= this.used) {
            return Bits.ofZero(this.used);
        }
        return Bits.ofZero(offset).append(this.subBits(0, this.used - offset));
    }

    public Bits rrShift(Bits offset) {
        return this.rrShift(offset.intLength());
    }

    public byte[] toByteArray() {
        int len = this.byteLength();
        byte[] data = new byte[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getByte(i).toByte();
        }
        return data;
    }

    public byte toByte() {
        return (byte)this.toLong();
    }

    public short[] toShortArray() {
        int len = this.shortLength();
        short[] data = new short[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getShort(i).toShort();
        }
        return data;
    }

    public short toShort() {
        return (short)this.toLong();
    }

    public int[] toIntArray() {
        int len = this.intLength();
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getInt(i).toInt();
        }
        return data;
    }

    public int toInt() {
        return (int)this.toLong();
    }

    public long[] toLongArray() {
        int len = this.longLength();
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getLong(i).toLong();
        }
        return data;
    }

    public long toLong() {
        boolean isPositive;
        Bits bits = this;
        boolean bl = isPositive = this.table[0] == Bit.ZERO;
        if (!isPositive) {
            bits = Bits.inverse(this);
        }
        long res = 0L;
        int i = bits.used - 1;
        int j = 0;
        while (i >= 0) {
            res += (long)(this.table[i].value() * Bits.pow(2, j));
            --i;
            ++j;
        }
        return res;
    }

    private static int pow(int m, int n) {
        int res = 1;
        for (int i = 0; i < n; ++i) {
            res *= m;
        }
        return res;
    }

    public static Bits ofByte(byte val) {
        return Bits.ofByte(val, 8);
    }

    public static Bits ofByte(byte val, int len) {
        Bits bits = new Bits();
        bits.expand(len);
        int i = 0;
        int j = len - 1;
        while (i < 7) {
            bits.table[j] = (val >> i & 1) == 1 ? Bit.ONE : Bit.ZERO;
            ++i;
            --j;
        }
        while (j >= 0) {
            bits.table[j] = val > 0 ? Bit.ZERO : Bit.ONE;
            --j;
        }
        bits.used += len;
        return bits;
    }

    public static Bits ofByte(byte[] val) {
        int i = 0;
        Bits first = Bits.ofByte(val[i++]);
        while (i < val.length) {
            first.append(Bits.ofByte(val[i]));
            ++i;
        }
        return first;
    }

    public static Bits ofShort(short val) {
        return Bits.ofShort(val, 16);
    }

    public static Bits ofShort(short val, int len) {
        Bits bits = new Bits();
        bits.expand(len);
        int i = 0;
        int j = len - 1;
        while (i < 15) {
            bits.table[j] = (val >> i & 1) == 1 ? Bit.ONE : Bit.ZERO;
            ++i;
            --j;
        }
        while (j >= 0) {
            bits.table[j] = val > 0 ? Bit.ZERO : Bit.ONE;
            --j;
        }
        bits.used += len;
        return bits;
    }

    public static Bits ofShort(short[] val) {
        int i = 0;
        Bits first = Bits.ofShort(val[i++]);
        while (i < val.length) {
            first.append(Bits.ofShort(val[i]));
            ++i;
        }
        return first;
    }

    public static Bits ofInt(int val) {
        return Bits.ofInt(val, 32);
    }

    public static Bits ofInt(int val, int len) {
        Bits bits = new Bits();
        bits.expand(len);
        int i = 0;
        int j = len - 1;
        while (i < 31) {
            bits.table[j] = (val >> i & 1) == 1 ? Bit.ONE : Bit.ZERO;
            ++i;
            --j;
        }
        while (j >= 0) {
            bits.table[j] = val > 0 ? Bit.ZERO : Bit.ONE;
            --j;
        }
        bits.used += len;
        return bits;
    }

    public static Bits ofInt(int[] val) {
        int i = 0;
        Bits first = Bits.ofInt(val[i++]);
        while (i < val.length) {
            first.append(Bits.ofInt(val[i]));
            ++i;
        }
        return first;
    }

    public Bits getByte(int index) {
        Bits subBits = this.subBits(index * 8, (index + 1) * 8);
        if (subBits.used < 8) {
            return Bits.ofZero(8 - subBits.used).append(subBits);
        }
        return subBits;
    }

    public Bits getShort(int index) {
        Bits subBits = this.subBits(index * 16, (index + 1) * 16);
        if (subBits.used < 16) {
            return Bits.ofZero(16 - subBits.used).append(subBits);
        }
        return subBits;
    }

    public Bits getInt(int index) {
        Bits subBits = this.subBits(index * 32, (index + 1) * 32);
        if (subBits.used < 32) {
            return Bits.ofZero(32 - subBits.used).append(subBits);
        }
        return subBits;
    }

    public Bits getLong(int index) {
        Bits subBits = this.subBits(index * 64, (index + 1) * 64);
        if (subBits.used < 64) {
            return Bits.ofZero(64 - subBits.used).append(subBits);
        }
        return subBits;
    }

    public int length() {
        return this.used;
    }

    public int byteLength() {
        return this.used / 8;
    }

    public int shortLength() {
        return this.used / 16;
    }

    public int intLength() {
        return this.used / 32;
    }

    public int longLength() {
        return this.used / 64;
    }

    public static Bits ofLong(long val) {
        return Bits.ofLong(val, 64);
    }

    public static Bits ofLong(long val, int len) {
        Bits bits = new Bits();
        bits.expand(len);
        int i = 0;
        int j = len - 1;
        while (i < 63) {
            bits.table[j] = (val >> i & 1L) == 1L ? Bit.ONE : Bit.ZERO;
            ++i;
            --j;
        }
        while (j >= 0) {
            bits.table[j] = val > 0L ? Bit.ZERO : Bit.ONE;
            --j;
        }
        bits.used += len;
        return bits;
    }

    public static Bits ofLong(long[] val) {
        int i = 0;
        Bits first = Bits.ofLong(val[i++]);
        while (i < val.length) {
            first.append(Bits.ofLong(val[i]));
            ++i;
        }
        return first;
    }

    public static Bits ofZero(int len) {
        Bits bits = new Bits();
        bits.expand(len);
        for (int i = 0; i < len; ++i) {
            bits.table[i] = Bit.ZERO;
        }
        bits.used += len;
        return bits;
    }

    public static Bits ofOne(int len) {
        Bits bits = new Bits();
        bits.expand(len);
        for (int i = 0; i < len; ++i) {
            bits.table[i] = Bit.ONE;
        }
        bits.used += len;
        return bits;
    }

    public Bits append(Bits other) {
        int newLen = this.used + other.used;
        this.expand(newLen);
        System.arraycopy(other.table, 0, this.table, this.used, other.used);
        this.used += other.used;
        return this;
    }

    private void expand(int newLen) {
        if (newLen <= this.size) {
            return;
        }
        Bits n = new Bits();
        n.size = newLen;
        n.table = new Bit[newLen];
        n.used = this.used;
        System.arraycopy(this.table, 0, n.table, 0, this.used);
        this.size = n.size;
        this.table = n.table;
        this.used = n.used;
    }

    public Bits subBits(int fromIndex, int toIndex) {
        Bits.subBitsRangeCheck(fromIndex, toIndex, this.used);
        Bits bits = new Bits();
        int newLen = toIndex - fromIndex;
        bits.expand(newLen);
        System.arraycopy(this.table, fromIndex, bits.table, 0, newLen);
        bits.used += newLen;
        return bits;
    }

    static void subBitsRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Bits{table=");
        for (int i = 0; i < this.used; ++i) {
            builder.append(this.table[i].value());
        }
        builder.append(", size=").append(this.size).append(", used=").append(this.used).append("}");
        return builder.toString();
    }
}

