/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.filter;

import com.github.myibu.algorithm.data.Bit;
import com.github.myibu.algorithm.hash.MurmurHash2;
import java.nio.charset.StandardCharsets;

public final class BloomFilter {
    private static final int DEFAULT_CAPACITY = 100;
    private static final double DEFAULT_ERROR_RATE = 0.01;
    private final Bloom bloom;

    public BloomFilter() {
        this(100, 0.01);
    }

    public BloomFilter(int capacity, double errorRate) {
        Bloom bloom = new Bloom();
        bloom.init(capacity, errorRate);
        this.bloom = bloom;
    }

    public void addAll(String[] values) {
        for (String value : values) {
            this.add(value);
        }
    }

    public void add(String value) {
        byte[] buffer = null == value ? new byte[]{} : value.getBytes(StandardCharsets.UTF_8);
        this.bloom.add(buffer, buffer.length);
    }

    public boolean contains(String value) {
        byte[] buffer = null == value ? new byte[]{} : value.getBytes(StandardCharsets.UTF_8);
        return this.bloom.check(buffer, buffer.length);
    }

    static class BloomHashVal {
        long a;
        long b;

        BloomHashVal() {
        }
    }

    static class Bloom {
        int size;
        double fpProb;
        int hashCount;
        Bit[] bitArray;

        Bloom() {
        }

        private int calcSize(int n, double p) {
            double m = -((double)n * Math.log(p)) / (Math.log(2.0) * Math.log(2.0));
            return (int)m;
        }

        private int calcHashCount(int m, int n) {
            double k = (double)m * 1.0 / (double)n * Math.log(2.0);
            return (int)k;
        }

        private BloomHashVal calcHashVal(byte[] buffer, int len) {
            BloomHashVal rv = new BloomHashVal();
            rv.a = MurmurHash2.hash(buffer, len, -1756908916L);
            rv.b = MurmurHash2.hash(buffer, len, rv.a);
            return rv;
        }

        void init(int itemCount, double fpProb) {
            this.fpProb = fpProb;
            this.size = this.calcSize(itemCount, fpProb);
            this.hashCount = this.calcHashCount(this.size, itemCount);
            this.bitArray = new Bit[this.size];
            int len = this.bitArray.length;
            for (int i = 0; i < len; ++i) {
                this.bitArray[i] = Bit.ZERO;
            }
        }

        void add(byte[] buffer, int len) {
            BloomHashVal hashVal = this.calcHashVal(buffer, len);
            for (int i = 0; i < this.hashCount; ++i) {
                int digest = (int)(Math.abs(hashVal.a + (long)i * hashVal.b) % (long)this.size);
                this.bitArray[digest] = Bit.ONE;
            }
        }

        boolean check(byte[] buffer, int len) {
            BloomHashVal hashVal = this.calcHashVal(buffer, len);
            for (int i = 0; i < this.hashCount; ++i) {
                int digest = (int)(Math.abs(hashVal.a + (long)i * hashVal.b) % (long)this.size);
                if (this.bitArray[digest] != Bit.ZERO) continue;
                return false;
            }
            return true;
        }
    }
}

