/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DictionaryTree {
    static final State START = new State();
    static final State END = new State();
    State root;

    public void insert(CharSequence word) {
        if (this.root == null) {
            this.root = START;
        }
        State cur = this.root;
        for (int pos = 0; pos < word.length(); ++pos) {
            char ch = word.charAt(pos);
            if (pos == word.length() - 1) {
                cur.transfer.put(Character.valueOf(ch), END);
                continue;
            }
            if (cur.transfer.containsKey(Character.valueOf(ch))) {
                cur = cur.transfer.get(Character.valueOf(ch));
                continue;
            }
            State newState = new State();
            cur.transfer.put(Character.valueOf(ch), newState);
            cur = newState;
        }
    }

    public void insertAll(String[] words) {
        for (String word : words) {
            this.insert(word);
        }
    }

    public List<String> search(CharSequence txt) {
        ArrayList<String> words = new ArrayList<String>();
        for (int i = 0; i < txt.length(); ++i) {
            String word = this.search(txt, i, txt.length());
            if (word == null) continue;
            words.add(word);
        }
        return words;
    }

    public String search(CharSequence txt, int start, int end) {
        char ch;
        int i;
        State cur = this.root;
        for (i = start; i < end && cur.transfer.containsKey(Character.valueOf(ch = txt.charAt(i))); ++i) {
            cur = cur.transfer.get(Character.valueOf(ch));
        }
        return cur == END ? txt.subSequence(start, i).toString() : null;
    }

    public static void main(String[] args) {
    }

    static class State {
        Map<Character, State> transfer = new HashMap<Character, State>();
    }
}

