/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;

public class SipHash {
    protected byte[] hashSeed;
    protected int c;
    protected int d;
    protected static final int DEFAULT_SEED_SIZE = 16;
    private static final String LINUX_RANDOM_FILE = "/dev/urandom";
    private long v0;
    private long v1;
    private long v2;
    private long v3;

    public SipHash() {
        this.hashSeed = this.generateHashSeed();
        this.c = 2;
        this.d = 4;
    }

    private byte[] generateHashSeed() {
        byte[] seed = new byte[16];
        boolean seedInitialized = false;
        File randomFile = Paths.get(LINUX_RANDOM_FILE, new String[0]).toFile();
        if (randomFile.exists() && randomFile.canRead()) {
            try {
                FileInputStream fis = new FileInputStream(randomFile);
                if (fis.read(seed, 0, seed.length) == 16) {
                    seedInitialized = true;
                }
            }
            catch (IOException fis) {
                // empty catch block
            }
        }
        if (!seedInitialized) {
            for (int j = 0; j < seed.length; ++j) {
                long sec = System.currentTimeMillis() / 1000L;
                long usec = System.nanoTime();
                long pid = Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
                seed[j] = (byte)(sec ^ usec ^ pid);
            }
        }
        return seed;
    }

    public SipHash(byte[] seed) {
        this(seed, 2, 4);
    }

    protected SipHash(byte[] seed, int c, int d) {
        if (null == seed || seed.length != 16) {
            throw new IllegalArgumentException("Seed can not be empty or the size of Seed is not equals to 16");
        }
        this.hashSeed = new byte[seed.length];
        System.arraycopy(seed, 0, this.hashSeed, 0, seed.length);
        this.c = c;
        this.d = d;
    }

    private void initialize(byte[] key) {
        this.v0 = 8317987319222330741L;
        this.v1 = 7237128888997146477L;
        this.v2 = 7816392313619706465L;
        this.v3 = 8387220255154660723L;
        long k0 = this.u8To64LE(key, 0);
        long k1 = this.u8To64LE(key, 8);
        this.v3 ^= k1;
        this.v2 ^= k0;
        this.v1 ^= k1;
        this.v0 ^= k0;
    }

    private void compress(byte[] message) {
        int end = message.length / 8;
        int left = message.length & 7;
        long b = (long)message.length << 56;
        for (int i = 0; i < end; ++i) {
            long m = this.u8To64LE(message, i * 8);
            this.v3 ^= m;
            for (int j = 0; j < this.c; ++j) {
                this.sipRound();
            }
            this.v0 ^= m;
        }
        switch (left) {
            case 7: {
                b |= (long)message[6] << 48;
            }
            case 6: {
                b |= (long)message[5] << 40;
            }
            case 5: {
                b |= (long)message[4] << 32;
            }
            case 4: {
                b |= (long)message[3] << 24;
            }
            case 3: {
                b |= (long)message[2] << 16;
            }
            case 2: {
                b |= (long)message[1] << 8;
            }
            case 1: {
                b |= (long)message[0];
                break;
            }
        }
        this.v3 ^= b;
        for (int j = 0; j < this.c; ++j) {
            this.sipRound();
        }
        this.v0 ^= b;
    }

    private long sipFinalize() {
        this.v2 ^= 0xFFL;
        for (int j = 0; j < this.d; ++j) {
            this.sipRound();
        }
        return this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
    }

    private long sipHash(byte[] key, byte[] message) {
        if (null == key || key.length != 16) {
            throw new IllegalArgumentException("key can not be empty or the size of key is not equals to 16");
        }
        if (null == message) {
            throw new IllegalArgumentException("message can not be empty");
        }
        this.initialize(key);
        this.compress(message);
        return this.sipFinalize();
    }

    private void sipRound() {
        this.v0 += this.v1;
        this.v1 = this.rotl(this.v1, 13);
        this.v1 ^= this.v0;
        this.v0 = this.rotl(this.v0, 32);
        this.v2 += this.v3;
        this.v3 = this.rotl(this.v3, 16);
        this.v3 ^= this.v2;
        this.v0 += this.v3;
        this.v3 = this.rotl(this.v3, 21);
        this.v3 ^= this.v0;
        this.v2 += this.v1;
        this.v1 = this.rotl(this.v1, 17);
        this.v1 ^= this.v2;
        this.v2 = this.rotl(this.v2, 32);
    }

    private long rotl(long x, int b) {
        return x << b | x >>> 64 - b;
    }

    private long u8To64LE(byte[] p, int offset) {
        return (long)p[offset] | (long)p[offset + 1] << 8 | (long)p[offset + 2] << 16 | (long)p[offset + 3] << 24 | (long)p[offset + 4] << 32 | (long)p[offset + 5] << 40 | (long)p[offset + 6] << 48 | (long)p[offset + 7] << 56;
    }

    public long hash(String key) {
        return this.sipHash(this.hashSeed, key.getBytes(StandardCharsets.UTF_8));
    }

    public long hash(String key, byte[] hashSeed) {
        return this.sipHash(hashSeed, key.getBytes(StandardCharsets.UTF_8));
    }
}

