/*
 * Decompiled with CFR 0.152.
 */
package com.github.myibu.algorithm.endode;

import com.github.myibu.algorithm.data.Bit;
import com.github.myibu.algorithm.data.Bits;
import com.github.myibu.algorithm.endode.Encoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HoffmanEncoder
implements Encoder {
    Symbol root;

    /*
     * WARNING - void declaration
     */
    public Bits encode(byte[] in_data, int in_len) {
        void var6_10;
        ArrayList<Object> probs = new ArrayList<Object>();
        for (int i = 0; i < in_len; ++i) {
            Symbol symbol = new Symbol(in_data[i], in_len);
            int n = probs.indexOf(symbol);
            if (n != -1) {
                ((Symbol)probs.get(n)).addTimes(1, in_len);
                continue;
            }
            probs.add(symbol);
        }
        ArrayList<Symbol> sortedProbs = new ArrayList<Symbol>();
        for (Symbol symbol : probs) {
            HoffmanEncoder.insertDescendingSort(sortedProbs, symbol);
        }
        ArrayList sortedProbsCopy = new ArrayList(sortedProbs);
        Object var6_9 = null;
        while (sortedProbs.size() > 1) {
            int len = sortedProbs.size();
            Symbol symbol = Symbol.merge((Symbol)sortedProbs.get(len - 2), (Symbol)sortedProbs.get(len - 1));
            sortedProbs.remove(sortedProbs.size() - 1);
            sortedProbs.remove(sortedProbs.size() - 1);
            HoffmanEncoder.insertDescendingSort(sortedProbs, symbol);
        }
        this.root = var6_10;
        HashMap<Byte, Bits> wordDict = new HashMap<Byte, Bits>(sortedProbsCopy.size());
        Iterator iterator = sortedProbsCopy.iterator();
        while (iterator.hasNext()) {
            Symbol sym;
            Symbol p = sym = (Symbol)iterator.next();
            Bits encodeBits = new Bits();
            while (p != var6_10) {
                encodeBits.append(p.bit);
                p = p.parent;
            }
            wordDict.put(sym.value, Bits.reverse(encodeBits));
        }
        System.out.println(wordDict);
        Bits seq = new Bits();
        for (int i = 0; i < in_len; ++i) {
            seq.append((Bits)wordDict.get(in_data[i]));
        }
        return seq;
    }

    private static void insertDescendingSort(List<Symbol> sortDest, Symbol target) {
        int insertIndex = -1;
        for (int i = sortDest.size() - 1; i >= 0; --i) {
            if (sortDest.get(i).compareTo(target) < 0) continue;
            insertIndex = i;
            break;
        }
        sortDest.add(insertIndex + 1, target);
    }

    public byte[] decode(Bits encodedBits) {
        int index = 0;
        byte[] res = new byte[encodedBits.length()];
        int resLen = 0;
        Symbol p = this.root;
        while (index < encodedBits.length() || p.isRaw) {
            if (p.isRaw) {
                res[resLen++] = p.value;
                System.out.println(p);
                p = this.root;
                continue;
            }
            p = encodedBits.get(index++) == Bit.ZERO ? p.left : p.right;
        }
        return Arrays.copyOf(res, resLen);
    }

    static class Symbol
    implements Comparable<Symbol> {
        byte value;
        int times;
        float probability;
        boolean isRaw;
        Bit bit;
        Symbol parent;
        Symbol left;
        Symbol right;

        public Symbol(byte value, float probability) {
            this.value = value;
            this.probability = probability;
            this.isRaw = true;
        }

        public Symbol(byte value, int total) {
            this.value = value;
            this.times = 1;
            this.probability = 1.0f / (float)total;
            this.isRaw = true;
        }

        public void addTimes(int times, int total) {
            this.times += times;
            this.probability = (float)this.times * 1.0f / (float)total;
        }

        public static Symbol merge(Symbol s1, Symbol s2) {
            s1.bit = Bit.ZERO;
            s2.bit = Bit.ONE;
            Symbol parent = new Symbol(0, s1.probability + s2.probability);
            parent.isRaw = false;
            parent.left = s1;
            parent.right = s2;
            s1.parent = parent;
            s2.parent = parent;
            return parent;
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + this.value;
            return hashCode;
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Symbol) {
                Symbol anotherSymbol = (Symbol)anObject;
                return this.value == anotherSymbol.value;
            }
            return false;
        }

        @Override
        public int compareTo(Symbol o) {
            if (o == null) {
                return Float.compare(this.probability, 0.0f);
            }
            return Float.compare(this.probability, o.probability);
        }

        public String toString() {
            return "Symbol{value=" + this.value + ", probability=" + this.probability + ", isRaw=" + this.isRaw + ", bit=" + this.bit + "}";
        }
    }
}

