/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.definition.LoadDefinition;
import internal.nbbrd.service.definition.LoadFilter;
import internal.nbbrd.service.definition.LoadSorter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class LoadData {
    private final List<LoadDefinition> definitions;
    private final List<LoadFilter> filters;
    private final List<LoadSorter> sorters;

    LoadData(List<LoadDefinition> definitions, List<LoadFilter> filters, List<LoadSorter> sorters) {
        this.definitions = definitions;
        this.filters = filters;
        this.sorters = sorters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<LoadDefinition> getDefinitions() {
        return this.definitions;
    }

    public List<LoadFilter> getFilters() {
        return this.filters;
    }

    public List<LoadSorter> getSorters() {
        return this.sorters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadData)) {
            return false;
        }
        LoadData other = (LoadData)o;
        List<LoadDefinition> this$definitions = this.getDefinitions();
        List<LoadDefinition> other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        List<LoadFilter> this$filters = this.getFilters();
        List<LoadFilter> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        List<LoadSorter> this$sorters = this.getSorters();
        List<LoadSorter> other$sorters = other.getSorters();
        return !(this$sorters == null ? other$sorters != null : !((Object)this$sorters).equals(other$sorters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LoadDefinition> $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        List<LoadFilter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        List<LoadSorter> $sorters = this.getSorters();
        result = result * 59 + ($sorters == null ? 43 : ((Object)$sorters).hashCode());
        return result;
    }

    public String toString() {
        return "LoadData(definitions=" + this.getDefinitions() + ", filters=" + this.getFilters() + ", sorters=" + this.getSorters() + ")";
    }

    public static class Builder {
        private ArrayList<LoadDefinition> definitions;
        private ArrayList<LoadFilter> filters;
        private ArrayList<LoadSorter> sorters;

        Builder() {
        }

        public Builder definition(LoadDefinition definition) {
            if (this.definitions == null) {
                this.definitions = new ArrayList();
            }
            this.definitions.add(definition);
            return this;
        }

        public Builder definitions(Collection<? extends LoadDefinition> definitions) {
            if (definitions == null) {
                throw new NullPointerException("definitions cannot be null");
            }
            if (this.definitions == null) {
                this.definitions = new ArrayList();
            }
            this.definitions.addAll(definitions);
            return this;
        }

        public Builder clearDefinitions() {
            if (this.definitions != null) {
                this.definitions.clear();
            }
            return this;
        }

        public Builder filter(LoadFilter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(filter);
            return this;
        }

        public Builder filters(Collection<? extends LoadFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("filters cannot be null");
            }
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.addAll(filters);
            return this;
        }

        public Builder clearFilters() {
            if (this.filters != null) {
                this.filters.clear();
            }
            return this;
        }

        public Builder sorter(LoadSorter sorter) {
            if (this.sorters == null) {
                this.sorters = new ArrayList();
            }
            this.sorters.add(sorter);
            return this;
        }

        public Builder sorters(Collection<? extends LoadSorter> sorters) {
            if (sorters == null) {
                throw new NullPointerException("sorters cannot be null");
            }
            if (this.sorters == null) {
                this.sorters = new ArrayList();
            }
            this.sorters.addAll(sorters);
            return this;
        }

        public Builder clearSorters() {
            if (this.sorters != null) {
                this.sorters.clear();
            }
            return this;
        }

        public LoadData build() {
            List<LoadSorter> sorters;
            List<LoadFilter> filters;
            List<LoadDefinition> definitions;
            switch (this.definitions == null ? 0 : this.definitions.size()) {
                case 0: {
                    definitions = Collections.emptyList();
                    break;
                }
                case 1: {
                    definitions = Collections.singletonList(this.definitions.get(0));
                    break;
                }
                default: {
                    definitions = Collections.unmodifiableList(new ArrayList<LoadDefinition>(this.definitions));
                }
            }
            switch (this.filters == null ? 0 : this.filters.size()) {
                case 0: {
                    filters = Collections.emptyList();
                    break;
                }
                case 1: {
                    filters = Collections.singletonList(this.filters.get(0));
                    break;
                }
                default: {
                    filters = Collections.unmodifiableList(new ArrayList<LoadFilter>(this.filters));
                }
            }
            switch (this.sorters == null ? 0 : this.sorters.size()) {
                case 0: {
                    sorters = Collections.emptyList();
                    break;
                }
                case 1: {
                    sorters = Collections.singletonList(this.sorters.get(0));
                    break;
                }
                default: {
                    sorters = Collections.unmodifiableList(new ArrayList<LoadSorter>(this.sorters));
                }
            }
            return new LoadData(definitions, filters, sorters);
        }

        public String toString() {
            return "LoadData.Builder(definitions=" + this.definitions + ", filters=" + this.filters + ", sorters=" + this.sorters + ")";
        }
    }
}

