/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.com.squareup.javapoet.ClassName;
import internal.nbbrd.service.ExtEnvironment;
import internal.nbbrd.service.definition.Lifecycle;
import internal.nbbrd.service.definition.TypeInstantiator;
import internal.nbbrd.service.definition.TypeWrapper;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import nbbrd.service.Quantifier;

final class LoadDefinition {
    private final Quantifier quantifier;
    private final Lifecycle lifecycle;
    private final ClassName serviceType;
    private final Optional<TypeInstantiator> fallback;
    private final Optional<TypeWrapper> wrapper;
    private final Optional<TypeInstantiator> preprocessor;
    private final String loaderName;

    public ClassName resolveLoaderName() {
        return LoadDefinition.resolveLoaderName(this.loaderName, this.serviceType);
    }

    static ClassName resolveLoaderName(String loaderName, ClassName serviceType) {
        if (!loaderName.isEmpty()) {
            return ClassName.bestGuess(loaderName);
        }
        ClassName top = serviceType.topLevelClassName();
        ClassName topLoader = ClassName.get(top.packageName(), top.simpleName() + "Loader", new String[0]);
        if (top.equals(serviceType)) {
            return topLoader;
        }
        return topLoader.nestedClass(serviceType.simpleName());
    }

    static DeclaredType getPreprocessorType(ExtEnvironment env, TypeElement service) {
        DeclaredType streamOf = env.getTypeUtils().getDeclaredType(env.asTypeElement(Stream.class), service.asType());
        return env.getTypeUtils().getDeclaredType(env.asTypeElement(UnaryOperator.class), streamOf);
    }

    LoadDefinition(Quantifier quantifier, Lifecycle lifecycle, ClassName serviceType, Optional<TypeInstantiator> fallback, Optional<TypeWrapper> wrapper, Optional<TypeInstantiator> preprocessor, String loaderName) {
        this.quantifier = quantifier;
        this.lifecycle = lifecycle;
        this.serviceType = serviceType;
        this.fallback = fallback;
        this.wrapper = wrapper;
        this.preprocessor = preprocessor;
        this.loaderName = loaderName;
    }

    public static LoadDefinitionBuilder builder() {
        return new LoadDefinitionBuilder();
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public ClassName getServiceType() {
        return this.serviceType;
    }

    public Optional<TypeInstantiator> getFallback() {
        return this.fallback;
    }

    public Optional<TypeWrapper> getWrapper() {
        return this.wrapper;
    }

    public Optional<TypeInstantiator> getPreprocessor() {
        return this.preprocessor;
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadDefinition)) {
            return false;
        }
        LoadDefinition other = (LoadDefinition)o;
        Quantifier this$quantifier = this.getQuantifier();
        Quantifier other$quantifier = other.getQuantifier();
        if (this$quantifier == null ? other$quantifier != null : !this$quantifier.equals(other$quantifier)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)((Object)this$lifecycle)).equals((Object)other$lifecycle)) {
            return false;
        }
        ClassName this$serviceType = this.getServiceType();
        ClassName other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !((Object)this$serviceType).equals(other$serviceType)) {
            return false;
        }
        Optional<TypeInstantiator> this$fallback = this.getFallback();
        Optional<TypeInstantiator> other$fallback = other.getFallback();
        if (this$fallback == null ? other$fallback != null : !((Object)this$fallback).equals(other$fallback)) {
            return false;
        }
        Optional<TypeWrapper> this$wrapper = this.getWrapper();
        Optional<TypeWrapper> other$wrapper = other.getWrapper();
        if (this$wrapper == null ? other$wrapper != null : !((Object)this$wrapper).equals(other$wrapper)) {
            return false;
        }
        Optional<TypeInstantiator> this$preprocessor = this.getPreprocessor();
        Optional<TypeInstantiator> other$preprocessor = other.getPreprocessor();
        if (this$preprocessor == null ? other$preprocessor != null : !((Object)this$preprocessor).equals(other$preprocessor)) {
            return false;
        }
        String this$loaderName = this.getLoaderName();
        String other$loaderName = other.getLoaderName();
        return !(this$loaderName == null ? other$loaderName != null : !this$loaderName.equals(other$loaderName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Quantifier $quantifier = this.getQuantifier();
        result = result * 59 + ($quantifier == null ? 43 : $quantifier.hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)((Object)$lifecycle)).hashCode());
        ClassName $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : ((Object)$serviceType).hashCode());
        Optional<TypeInstantiator> $fallback = this.getFallback();
        result = result * 59 + ($fallback == null ? 43 : ((Object)$fallback).hashCode());
        Optional<TypeWrapper> $wrapper = this.getWrapper();
        result = result * 59 + ($wrapper == null ? 43 : ((Object)$wrapper).hashCode());
        Optional<TypeInstantiator> $preprocessor = this.getPreprocessor();
        result = result * 59 + ($preprocessor == null ? 43 : ((Object)$preprocessor).hashCode());
        String $loaderName = this.getLoaderName();
        result = result * 59 + ($loaderName == null ? 43 : $loaderName.hashCode());
        return result;
    }

    public String toString() {
        return "LoadDefinition(quantifier=" + this.getQuantifier() + ", lifecycle=" + (Object)((Object)this.getLifecycle()) + ", serviceType=" + this.getServiceType() + ", fallback=" + this.getFallback() + ", wrapper=" + this.getWrapper() + ", preprocessor=" + this.getPreprocessor() + ", loaderName=" + this.getLoaderName() + ")";
    }

    public static class LoadDefinitionBuilder {
        private Quantifier quantifier;
        private Lifecycle lifecycle;
        private ClassName serviceType;
        private Optional<TypeInstantiator> fallback;
        private Optional<TypeWrapper> wrapper;
        private Optional<TypeInstantiator> preprocessor;
        private String loaderName;

        LoadDefinitionBuilder() {
        }

        public LoadDefinitionBuilder quantifier(Quantifier quantifier) {
            this.quantifier = quantifier;
            return this;
        }

        public LoadDefinitionBuilder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public LoadDefinitionBuilder serviceType(ClassName serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public LoadDefinitionBuilder fallback(Optional<TypeInstantiator> fallback) {
            this.fallback = fallback;
            return this;
        }

        public LoadDefinitionBuilder wrapper(Optional<TypeWrapper> wrapper) {
            this.wrapper = wrapper;
            return this;
        }

        public LoadDefinitionBuilder preprocessor(Optional<TypeInstantiator> preprocessor) {
            this.preprocessor = preprocessor;
            return this;
        }

        public LoadDefinitionBuilder loaderName(String loaderName) {
            this.loaderName = loaderName;
            return this;
        }

        public LoadDefinition build() {
            return new LoadDefinition(this.quantifier, this.lifecycle, this.serviceType, this.fallback, this.wrapper, this.preprocessor, this.loaderName);
        }

        public String toString() {
            return "LoadDefinition.LoadDefinitionBuilder(quantifier=" + this.quantifier + ", lifecycle=" + (Object)((Object)this.lifecycle) + ", serviceType=" + this.serviceType + ", fallback=" + this.fallback + ", wrapper=" + this.wrapper + ", preprocessor=" + this.preprocessor + ", loaderName=" + this.loaderName + ")";
        }
    }
}

