/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.com.squareup.javapoet.ClassName;
import internal.com.squareup.javapoet.CodeBlock;
import internal.com.squareup.javapoet.FieldSpec;
import internal.com.squareup.javapoet.MethodSpec;
import internal.com.squareup.javapoet.ParameterizedTypeName;
import internal.com.squareup.javapoet.TypeName;
import internal.com.squareup.javapoet.TypeSpec;
import internal.nbbrd.service.Instantiator;
import internal.nbbrd.service.Unreachable;
import internal.nbbrd.service.Wrapper;
import internal.nbbrd.service.definition.Lifecycle;
import internal.nbbrd.service.definition.LoadDefinition;
import internal.nbbrd.service.definition.LoadFilter;
import internal.nbbrd.service.definition.LoadSorter;
import internal.nbbrd.service.definition.TypeInstantiator;
import internal.nbbrd.service.definition.TypeWrapper;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import nbbrd.service.Quantifier;

final class ServiceDefinitionGenerator {
    private final LoadDefinition definition;
    private final List<LoadFilter> filters;
    private final List<LoadSorter> sorters;
    private static final Modifier[] NO_MODIFIER = new Modifier[0];
    private static final Modifier[] SINGLETON_MODIFIER = new Modifier[]{Modifier.STATIC};

    public static List<ServiceDefinitionGenerator> allOf(List<LoadDefinition> definitions, Map<ClassName, List<LoadFilter>> filtersByService, Map<ClassName, List<LoadSorter>> sortersByService) {
        return definitions.stream().map(definition -> ServiceDefinitionGenerator.of(definition, filtersByService, sortersByService)).collect(Collectors.toList());
    }

    public static ServiceDefinitionGenerator of(LoadDefinition definition, Map<ClassName, List<LoadFilter>> filtersByService, Map<ClassName, List<LoadSorter>> sortersByService) {
        return new ServiceDefinitionGenerator(definition, filtersByService.getOrDefault(definition.getServiceType(), Collections.emptyList()), sortersByService.getOrDefault(definition.getServiceType(), Collections.emptyList()));
    }

    public TypeSpec generate(boolean nested) {
        String className = this.definition.resolveLoaderName().simpleName();
        TypeName quantifierType = this.getQuantifierType();
        FieldSpec sourceField = this.newSourceField();
        MethodSpec doLoadMethod = this.newDoLoadMethod(sourceField, quantifierType);
        FieldSpec resourceField = this.newResourceField(doLoadMethod, quantifierType);
        MethodSpec getMethod = this.newGetMethod(resourceField, quantifierType);
        TypeSpec.Builder result = TypeSpec.classBuilder(className).addJavadoc(this.getMainJavadoc()).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addField(sourceField).addMethod(doLoadMethod).addField(resourceField).addMethod(getMethod);
        if (nested) {
            result.addModifiers(Modifier.STATIC).build();
        }
        if (this.definition.getLifecycle().isSingleton()) {
            result.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        }
        if (this.definition.getLifecycle().isModifiable()) {
            result.addMethod(this.newSetMethod(resourceField, quantifierType));
            result.addMethod(this.newReloadMethod(sourceField, doLoadMethod));
            result.addMethod(this.newResetMethod(sourceField, doLoadMethod));
        }
        if (this.definition.getLifecycle() == Lifecycle.IMMUTABLE) {
            result.addMethod(this.newLoadMethod(className, quantifierType, getMethod));
        }
        return result.build();
    }

    private CodeBlock getMainJavadoc() {
        return CodeBlock.builder().add("Custom service loader for $L.\n", ServiceDefinitionGenerator.toJavadocLink(this.definition.getServiceType())).add("<br>This class $L thread-safe.\n", this.definition.getLifecycle().isThreadSafe() ? "is" : "is not").add("<p>Properties:\n", new Object[0]).add("<ul>\n", new Object[0]).add("<li>Quantifier: $L</li>\n", this.definition.getQuantifier()).add("<li>Fallback: $L</li>\n", ServiceDefinitionGenerator.toJavadocLink(this.definition.getFallback())).add("<li>Preprocessing: $L</li>\n", this.getPreprocessingJavadoc()).add("<li>Mutability: $L</li>\n", this.definition.getLifecycle().toMutability()).add("<li>Singleton: $L</li>\n", this.definition.getLifecycle().isSingleton()).add("<li>Name: $L</li>\n", this.definition.getLoaderName().isEmpty() ? "null" : this.definition.getLoaderName()).add("</ul>\n", new Object[0]).build();
    }

    private String getPreprocessingJavadoc() {
        return this.definition.getPreprocessor().isPresent() ? this.getAdvancedPreprocessingJavadoc() : this.getBasicPreprocessingJavadoc();
    }

    private String getAdvancedPreprocessingJavadoc() {
        return ServiceDefinitionGenerator.toJavadocLink(this.definition.getPreprocessor());
    }

    private String getBasicPreprocessingJavadoc() {
        if (this.definition.getWrapper().isPresent() || !this.filters.isEmpty() || !this.sorters.isEmpty()) {
            return "wrapper: " + this.definition.getWrapper().map(wrapper -> wrapper.getType().toString()).orElse("none") + " filters:" + this.filters.stream().map(o -> ServiceDefinitionGenerator.getMethodName(o.getMethod())).collect(Collectors.joining("+", "[", "]")) + " sorters:" + this.sorters.stream().map(o -> ServiceDefinitionGenerator.getMethodName(o.getMethod())).collect(Collectors.joining("+", "[", "]"));
        }
        return "null";
    }

    private MethodSpec newDoLoadMethod(FieldSpec sourceField, TypeName quantifierType) {
        return MethodSpec.methodBuilder("doLoad").addModifiers(Modifier.PRIVATE).addModifiers(this.getSingletonModifiers()).returns(quantifierType).addExceptions(this.getQuantifierException()).addStatement(CodeBlock.builder().add("return ", new Object[0]).add(this.getPreprocessingCode(sourceField)).add(this.getQuantifierCode()).build()).build();
    }

    private CodeBlock getPreprocessingCode(FieldSpec sourceField) {
        CodeBlock streamBlock = CodeBlock.of("$T.stream($N.spliterator(), false)", StreamSupport.class, sourceField);
        return this.definition.getPreprocessor().isPresent() ? this.getAdvancedPreprocessingCode(streamBlock) : this.getBasicPreprocessingCode(streamBlock);
    }

    private CodeBlock getAdvancedPreprocessingCode(CodeBlock streamBlock) {
        return CodeBlock.of("$L\n.apply($L)", this.getInstantiatorCode(this.definition.getPreprocessor().get()), streamBlock);
    }

    private CodeBlock getBasicPreprocessingCode(CodeBlock streamBlock) {
        CodeBlock.Builder result = CodeBlock.builder();
        result.add(streamBlock);
        if (this.definition.getWrapper().isPresent()) {
            result.add("\n.map($L)", this.getWrapperCode(this.definition.getWrapper().get()));
            result.add("\n.map($T.class::cast)", this.definition.getServiceType());
        }
        if (!this.filters.isEmpty()) {
            result.add("\n.filter($L)", this.getFiltersCode(this.filters));
        }
        if (!this.sorters.isEmpty()) {
            result.add("\n.sorted($L)", this.getSortersCode(this.sorters));
        }
        return result.build();
    }

    private CodeBlock getFiltersCode(List<LoadFilter> filters) {
        Iterator filterIter = filters.stream().sorted(Comparator.comparingInt(LoadFilter::getPosition)).map(this::getFilterCode).iterator();
        CodeBlock first = (CodeBlock)filterIter.next();
        if (!filterIter.hasNext()) {
            return first;
        }
        CodeBlock.Builder result = CodeBlock.builder();
        result.add("(($T<$T>)$L)", Predicate.class, this.definition.getServiceType(), first);
        while (filterIter.hasNext()) {
            result.add(".and($L)", filterIter.next());
        }
        return result.build();
    }

    private CodeBlock getFilterCode(LoadFilter filter) {
        CodeBlock result = CodeBlock.of("$T::$L", filter.getServiceType().orElseThrow(Unreachable::new), ServiceDefinitionGenerator.getMethodName(filter.getMethod()));
        return filter.isNegate() ? CodeBlock.of("(($T<$T>)$L).negate()", Predicate.class, this.definition.getServiceType(), result) : result;
    }

    private CodeBlock getSortersCode(List<LoadSorter> sorters) {
        Iterator iter = sorters.stream().sorted(Comparator.comparingInt(LoadSorter::getPosition)).map(this::getSorterCode).iterator();
        CodeBlock first = (CodeBlock)iter.next();
        if (!iter.hasNext()) {
            return first;
        }
        CodeBlock.Builder result = CodeBlock.builder();
        result.add("(($T<$T>)$L)", Comparator.class, this.definition.getServiceType(), first);
        while (iter.hasNext()) {
            result.add(".thenComparing($L)", iter.next());
        }
        return result.build();
    }

    private CodeBlock getSorterCode(LoadSorter sorter) {
        CodeBlock result = CodeBlock.of("$T.$L($T::$L)", Comparator.class, this.getComparatorMethod(sorter), sorter.getServiceType().orElseThrow(Unreachable::new), ServiceDefinitionGenerator.getMethodName(sorter.getMethod()));
        return sorter.isReverse() ? CodeBlock.of("$T.reverseOrder($L)", Collections.class, result) : result;
    }

    private String getComparatorMethod(LoadSorter sorter) {
        switch (sorter.getKeyType().get()) {
            case COMPARABLE: {
                return "comparing";
            }
            case DOUBLE: {
                return "comparingDouble";
            }
            case INT: {
                return "comparingInt";
            }
            case LONG: {
                return "comparingLong";
            }
        }
        throw new Unreachable();
    }

    private CodeBlock getQuantifierCode() {
        switch (this.definition.getQuantifier()) {
            case OPTIONAL: {
                return CodeBlock.of("\n.findFirst()", new Object[0]);
            }
            case SINGLE: {
                return this.definition.getFallback().isPresent() ? CodeBlock.of("\n.findFirst()\n.orElseGet(() -> $L)", this.getInstantiatorCode(this.definition.getFallback().get())) : CodeBlock.of("\n.findFirst()\n.orElseThrow(() -> new $T(\"Missing mandatory provider of $T\"))", IllegalStateException.class, this.definition.getServiceType());
            }
            case MULTIPLE: {
                return CodeBlock.of("\n.collect($T.collectingAndThen($T.toList(), $T::unmodifiableList))", Collectors.class, Collectors.class, Collections.class);
            }
        }
        throw new Unreachable();
    }

    private CodeBlock getInstantiatorCode(TypeInstantiator instance) {
        Instantiator instantiator = instance.select().orElseThrow(RuntimeException::new);
        switch (instantiator.getKind()) {
            case CONSTRUCTOR: {
                return CodeBlock.of("new $T()", instance.getType());
            }
            case STATIC_METHOD: {
                return CodeBlock.of("$T.$L()", instance.getType(), instantiator.getElement().getSimpleName());
            }
            case ENUM_FIELD: 
            case STATIC_FIELD: {
                return CodeBlock.of("$T.$L", instance.getType(), instantiator.getElement().getSimpleName());
            }
        }
        throw new Unreachable();
    }

    private CodeBlock getWrapperCode(TypeWrapper instance) {
        Wrapper wrapper = instance.select().orElseThrow(RuntimeException::new);
        switch (wrapper.getKind()) {
            case CONSTRUCTOR: {
                return CodeBlock.of("$T::new", instance.getType());
            }
            case STATIC_METHOD: {
                return CodeBlock.of("$T::$L", instance.getType(), wrapper.getElement().getSimpleName());
            }
        }
        throw new Unreachable();
    }

    private TypeName getQuantifierType() {
        switch (this.definition.getQuantifier()) {
            case OPTIONAL: {
                return ServiceDefinitionGenerator.typeOf(Optional.class, this.definition.getServiceType());
            }
            case SINGLE: {
                return this.definition.getServiceType();
            }
            case MULTIPLE: {
                return ServiceDefinitionGenerator.typeOf(List.class, this.definition.getServiceType());
            }
        }
        throw new Unreachable();
    }

    private List<TypeName> getQuantifierException() {
        return this.definition.getQuantifier() == Quantifier.SINGLE && !this.definition.getFallback().isPresent() ? Collections.singletonList(ClassName.get(IllegalStateException.class)) : Collections.emptyList();
    }

    private FieldSpec newSourceField() {
        return FieldSpec.builder(ServiceDefinitionGenerator.typeOf(ServiceLoader.class, this.definition.getServiceType()), this.fieldName("source"), new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.FINAL).addModifiers(this.getSingletonModifiers()).initializer("$T.load($T.class)", ServiceLoader.class, this.definition.getServiceType()).build();
    }

    private FieldSpec newResourceField(MethodSpec doLoadMethod, TypeName quantifierType) {
        return this.getResourceFieldBuilder(quantifierType).addModifiers(this.getSingletonModifiers()).initializer(this.getResourceInitializer(doLoadMethod)).build();
    }

    private FieldSpec.Builder getResourceFieldBuilder(TypeName quantifierType) {
        String name = this.fieldName("resource");
        switch (this.definition.getLifecycle()) {
            case IMMUTABLE: 
            case CONSTANT: {
                return FieldSpec.builder(quantifierType, name, Modifier.PRIVATE, Modifier.FINAL);
            }
            case MUTABLE: 
            case UNSAFE_MUTABLE: {
                return FieldSpec.builder(quantifierType, name, Modifier.PRIVATE);
            }
            case CONCURRENT: 
            case ATOMIC: {
                return FieldSpec.builder(ServiceDefinitionGenerator.typeOf(AtomicReference.class, quantifierType), name, Modifier.PRIVATE, Modifier.FINAL);
            }
        }
        throw new Unreachable();
    }

    private CodeBlock getResourceInitializer(MethodSpec doLoadMethod) {
        return this.definition.getLifecycle().isAtomicReference() ? CodeBlock.of("new $T<>($N())", ClassName.get(AtomicReference.class), doLoadMethod) : CodeBlock.of("$N()", doLoadMethod);
    }

    private MethodSpec newGetMethod(FieldSpec resourceField, TypeName quantifierType) {
        return MethodSpec.methodBuilder("get").addJavadoc(CodeBlock.builder().add(this.getGetDescription()).add(this.getThreadSafetyComment()).add("@return the current non-null value\n", new Object[0]).build()).addModifiers(Modifier.PUBLIC).addModifiers(this.getSingletonModifiers()).returns(quantifierType).addStatement(this.getGetterStatement(resourceField)).build();
    }

    private CodeBlock getGetDescription() {
        switch (this.definition.getQuantifier()) {
            case OPTIONAL: {
                return CodeBlock.of("Gets an optional $L instance.\n", ServiceDefinitionGenerator.toJavadocLink(this.definition.getServiceType()));
            }
            case SINGLE: {
                return CodeBlock.of("Gets a $L instance.\n", ServiceDefinitionGenerator.toJavadocLink(this.definition.getServiceType()));
            }
            case MULTIPLE: {
                return CodeBlock.of("Gets a list of $L instances.\n", ServiceDefinitionGenerator.toJavadocLink(this.definition.getServiceType()));
            }
        }
        throw new Unreachable();
    }

    private CodeBlock getGetterStatement(FieldSpec resourceField) {
        return this.definition.getLifecycle().isAtomicReference() ? CodeBlock.of("return $N.get()", resourceField) : CodeBlock.of("return $N", resourceField);
    }

    private MethodSpec newSetMethod(FieldSpec resourceField, TypeName quantifierType) {
        return MethodSpec.methodBuilder("set").addJavadoc(CodeBlock.builder().add(this.getSetDescription()).add(this.getThreadSafetyComment()).add("@param newValue new non-null value\n", new Object[0]).build()).addModifiers(Modifier.PUBLIC).addModifiers(this.getSingletonModifiers()).addParameter(quantifierType, "newValue", new Modifier[0]).addStatement(this.getSetterStatement(resourceField)).build();
    }

    private CodeBlock getSetDescription() {
        switch (this.definition.getQuantifier()) {
            case OPTIONAL: {
                return CodeBlock.of("Sets an optional $L instance.\n", ServiceDefinitionGenerator.toJavadocLink(this.definition.getServiceType()));
            }
            case SINGLE: {
                return CodeBlock.of("Sets a $L instance.\n", ServiceDefinitionGenerator.toJavadocLink(this.definition.getServiceType()));
            }
            case MULTIPLE: {
                return CodeBlock.of("Sets a list of $L instances.\n", ServiceDefinitionGenerator.toJavadocLink(this.definition.getServiceType()));
            }
        }
        throw new Unreachable();
    }

    private CodeBlock getSetterStatement(FieldSpec resourceField) {
        return this.definition.getLifecycle().isAtomicReference() ? CodeBlock.of("$N.set($T.requireNonNull(newValue))", resourceField, Objects.class) : CodeBlock.of("$N = $T.requireNonNull(newValue)", resourceField, Objects.class);
    }

    private MethodSpec newReloadMethod(FieldSpec sourceField, MethodSpec loaderMethod) {
        MethodSpec.Builder result = MethodSpec.methodBuilder("reload").addJavadoc(CodeBlock.builder().add("Reloads the content by clearing the cache and fetching available providers.\n", new Object[0]).add(this.getThreadSafetyComment()).build()).addModifiers(Modifier.PUBLIC).addModifiers(this.getSingletonModifiers()).addExceptions(this.getQuantifierException());
        if (this.definition.getLifecycle().isAtomicReference()) {
            result.beginControlFlow("synchronized($N)", sourceField);
        }
        result.addStatement("$N.reload()", sourceField);
        result.addStatement("set($N())", loaderMethod);
        if (this.definition.getLifecycle().isAtomicReference()) {
            result.endControlFlow();
        }
        return result.build();
    }

    private MethodSpec newResetMethod(FieldSpec sourceField, MethodSpec loaderMethod) {
        MethodSpec.Builder result = MethodSpec.methodBuilder("reset").addJavadoc(CodeBlock.builder().add("Resets the content without clearing the cache.\n", new Object[0]).add(this.getThreadSafetyComment()).build()).addModifiers(Modifier.PUBLIC).addModifiers(this.getSingletonModifiers()).addExceptions(this.getQuantifierException());
        if (this.definition.getLifecycle().isAtomicReference()) {
            result.beginControlFlow("synchronized($N)", sourceField);
        }
        result.addStatement("set($N())", loaderMethod);
        if (this.definition.getLifecycle().isAtomicReference()) {
            result.endControlFlow();
        }
        return result.build();
    }

    private MethodSpec newLoadMethod(String className, TypeName quantifierType, MethodSpec getter) {
        CodeBlock mainStatement = CodeBlock.of("new $L().$N()", className, getter);
        MethodSpec.Builder result = MethodSpec.methodBuilder("load").addJavadoc(CodeBlock.builder().add(this.getGetDescription()).add("<br>This is equivalent to the following code: <code>$L</code>\n", mainStatement).add("<br>Therefore, the returned value might be different at each call.\n", new Object[0]).add(this.getThreadSafetyComment()).add("@return a non-null value\n", new Object[0]).build()).addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(quantifierType).addExceptions(this.getQuantifierException());
        result.addStatement("return $L", mainStatement);
        return result.build();
    }

    private Modifier[] getSingletonModifiers() {
        return this.definition.getLifecycle().isSingleton() ? SINGLETON_MODIFIER : NO_MODIFIER;
    }

    private String fieldName(String name) {
        return this.definition.getLifecycle().isSingleton() ? name.toUpperCase() : name;
    }

    private CodeBlock getThreadSafetyComment() {
        return this.definition.getLifecycle().isThreadSafe() ? CodeBlock.of("<br>This method is thread-safe.\n", new Object[0]) : CodeBlock.of("<br>This method is not thread-safe.\n", new Object[0]);
    }

    private static ParameterizedTypeName typeOf(Class<?> rawType, TypeName typeArgument) {
        return ParameterizedTypeName.get(ClassName.get(rawType), typeArgument);
    }

    private static String toJavadocLink(ClassName type) {
        return "{@link " + type + "}";
    }

    private static String toJavadocLink(Optional<TypeInstantiator> type) {
        return type.map(o -> "{@link " + o.getType() + "}").orElse("null");
    }

    private static String getMethodName(ExecutableElement x) {
        return x.getSimpleName().toString();
    }

    public ServiceDefinitionGenerator(LoadDefinition definition, List<LoadFilter> filters, List<LoadSorter> sorters) {
        this.definition = definition;
        this.filters = filters;
        this.sorters = sorters;
    }

    public LoadDefinition getDefinition() {
        return this.definition;
    }

    public List<LoadFilter> getFilters() {
        return this.filters;
    }

    public List<LoadSorter> getSorters() {
        return this.sorters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDefinitionGenerator)) {
            return false;
        }
        ServiceDefinitionGenerator other = (ServiceDefinitionGenerator)o;
        LoadDefinition this$definition = this.getDefinition();
        LoadDefinition other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !((Object)this$definition).equals(other$definition)) {
            return false;
        }
        List<LoadFilter> this$filters = this.getFilters();
        List<LoadFilter> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        List<LoadSorter> this$sorters = this.getSorters();
        List<LoadSorter> other$sorters = other.getSorters();
        return !(this$sorters == null ? other$sorters != null : !((Object)this$sorters).equals(other$sorters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoadDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : ((Object)$definition).hashCode());
        List<LoadFilter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        List<LoadSorter> $sorters = this.getSorters();
        result = result * 59 + ($sorters == null ? 43 : ((Object)$sorters).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceDefinitionGenerator(definition=" + this.getDefinition() + ", filters=" + this.getFilters() + ", sorters=" + this.getSorters() + ")";
    }
}

