/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import internal.nbbrd.service.ProcessorUtil;
import internal.nbbrd.service.provider.ProviderRef;
import internal.nbbrd.service.provider.ProviderRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import lombok.NonNull;
import nbbrd.service.ServiceProvider;

final class AnnotationRegistry
implements ProviderRegistry {
    @NonNull
    private final Set<? extends TypeElement> annotations;
    @NonNull
    private final RoundEnvironment roundEnv;

    public List<ProviderRef> readAll() {
        return this.annotations.stream().map(this.roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream).map(TypeElement.class::cast).flatMap(AnnotationRegistry::newRefs).collect(Collectors.toList());
    }

    static Stream<ProviderRef> newRefs(TypeElement type) {
        return AnnotationRegistry.getAnnotations(type).map(annotation -> AnnotationRegistry.getServiceType(annotation, type)).map(service -> new ProviderRef((TypeElement)service, type));
    }

    static Stream<ServiceProvider> getAnnotations(TypeElement type) {
        ServiceProvider.List list = type.getAnnotation(ServiceProvider.List.class);
        return list == null ? Stream.of(type.getAnnotation(ServiceProvider.class)) : Stream.of(list.value());
    }

    static TypeElement getServiceType(ServiceProvider annotation, TypeElement type) {
        return (TypeElement)((DeclaredType)AnnotationRegistry.getServiceTypeMirror(annotation, type)).asElement();
    }

    static TypeMirror getServiceTypeMirror(ServiceProvider annotation, TypeElement type) {
        TypeMirror serviceType = ProcessorUtil.extractResultType(() -> ((ServiceProvider)annotation).value());
        return AnnotationRegistry.isNullValue(serviceType) ? AnnotationRegistry.inferServiceType(type).orElse(serviceType) : serviceType;
    }

    static boolean isNullValue(TypeMirror serviceType) {
        return serviceType.toString().equals(Void.class.getName());
    }

    static Optional<TypeMirror> inferServiceType(TypeElement type) {
        List<? extends TypeMirror> parents = type.getInterfaces();
        return parents.size() == 1 ? Optional.of(parents.get(0)) : Optional.empty();
    }

    public AnnotationRegistry(@NonNull Set<? extends TypeElement> annotations, @NonNull RoundEnvironment roundEnv) {
        if (annotations == null) {
            throw new NullPointerException("annotations is marked non-null but is null");
        }
        if (roundEnv == null) {
            throw new NullPointerException("roundEnv is marked non-null but is null");
        }
        this.annotations = annotations;
        this.roundEnv = roundEnv;
    }
}

