/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import internal.nbbrd.service.Instantiator;
import internal.nbbrd.service.provider.AnnotationRegistry;
import internal.nbbrd.service.provider.ClassPathRegistry;
import internal.nbbrd.service.provider.ModulePathRegistry;
import internal.nbbrd.service.provider.ProviderEntry;
import internal.nbbrd.service.provider.ProviderRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"nbbrd.service.ServiceProvider", "nbbrd.service.ServiceProvider.List"})
public final class ServiceProviderProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        List<ProviderRef> annotationRefs = new AnnotationRegistry(annotations, roundEnv).readAll();
        if (annotationRefs.isEmpty()) {
            return true;
        }
        this.log("Annotation", annotationRefs);
        this.checkRefs(annotationRefs);
        try {
            this.checkModulePath(annotationRefs, new ModulePathRegistry(this.processingEnv));
            this.registerClassPath(annotationRefs, new ClassPathRegistry(this.processingEnv));
        }
        catch (IOException ex) {
            String msg = ex.getClass().getSimpleName() + ": " + ex.getMessage();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
        return true;
    }

    private void checkRefs(List<ProviderRef> refs) {
        ProviderRef.getDuplicates(refs).forEach(ref -> this.error((ProviderRef)ref, String.format("Duplicated provider: '%1$s'", ref.getProvider())));
        refs.forEach(this::checkRef);
    }

    private void checkRef(ProviderRef ref) {
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        if (types.isSameType(ref.getService().asType(), elements.getTypeElement(Void.class.getName()).asType())) {
            this.error(ref, "Cannot infer service from provider " + ref.getProvider());
            return;
        }
        if (!types.isAssignable(ref.getProvider().asType(), types.erasure(ref.getService().asType()))) {
            this.error(ref, String.format("Provider '%1$s' doesn't extend nor implement service '%2$s'", ref.getProvider(), ref.getService()));
            return;
        }
        if (ref.getProvider().getEnclosingElement().getKind() == ElementKind.CLASS && !ref.getProvider().getModifiers().contains((Object)Modifier.STATIC)) {
            this.error(ref, String.format("Provider '%1$s' must be static inner class", ref.getProvider()));
            return;
        }
        if (ref.getProvider().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.error(ref, String.format("Provider '%1$s' must not be abstract", ref.getProvider()));
            return;
        }
        if (Instantiator.allOf(types, ref.getService(), ref.getProvider()).stream().noneMatch(this::isValidInstantiator)) {
            this.error(ref, String.format("Provider '%1$s' must have a public no-argument constructor", ref.getProvider()));
            return;
        }
    }

    private boolean isValidInstantiator(Instantiator instantiator) {
        switch (instantiator.getKind()) {
            case CONSTRUCTOR: {
                return true;
            }
            case STATIC_METHOD: {
                return ((ExecutableElement)instantiator.getElement()).getSimpleName().contentEquals("provider");
            }
        }
        return false;
    }

    private void log(String id, List<ProviderRef> refs) {
        refs.forEach(ref -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("%1$s: %2$s", id, ref)));
    }

    private void logEntries(String id, List<ProviderEntry> entries) {
        entries.forEach(entry -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("%1$s: %2$s", id, entry)));
    }

    private void error(ProviderRef ref, String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, ref.getProvider());
    }

    private void errorEntry(ProviderEntry entry, String message) {
        TypeElement optionalType = this.processingEnv.getElementUtils().getTypeElement(entry.getProvider());
        if (optionalType != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, optionalType);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
        }
    }

    private void checkModulePath(List<ProviderRef> annotationRefs, ModulePathRegistry modulePath) throws IOException {
        modulePath.readAll().ifPresent(modulePathEntries -> {
            this.logEntries("ModulePath", (List<ProviderEntry>)modulePathEntries);
            ServiceProviderProcessor.getMissingRefs(annotationRefs, modulePathEntries).forEachOrdered(ref -> this.error((ProviderRef)ref, "Missing module-info.java 'provides' directive for '" + ref + "'"));
            System.out.println(Arrays.toString(annotationRefs.toArray()));
            System.out.println(Arrays.toString(modulePathEntries.toArray()));
            ServiceProviderProcessor.getMissingEntries(annotationRefs, modulePathEntries).forEachOrdered(entry -> this.errorEntry((ProviderEntry)entry, "Missing annotation for '" + entry + "'"));
        });
    }

    static Stream<ProviderRef> getMissingRefs(List<ProviderRef> annotationRefs, List<ProviderEntry> modulePathEntries) {
        return annotationRefs.stream().filter(ref -> !modulePathEntries.contains(ref.toEntry()));
    }

    static Stream<ProviderEntry> getMissingEntries(List<ProviderRef> annotationRefs, List<ProviderEntry> modulePathEntries) {
        Set annotationEntries = annotationRefs.stream().map(ProviderRef::toEntry).collect(Collectors.toSet());
        return modulePathEntries.stream().filter(entry -> !annotationEntries.contains(entry));
    }

    private void registerClassPath(List<ProviderRef> annotationRefs, ClassPathRegistry classPath) throws IOException {
        Map<TypeElement, List<ProviderRef>> refByService = annotationRefs.stream().collect(Collectors.groupingBy(ProviderRef::getService));
        for (Map.Entry<TypeElement, List<ProviderRef>> x : refByService.entrySet()) {
            List<String> oldLines = classPath.readLinesByService(x.getKey());
            this.logEntries("ClassPath", classPath.parseAll(x.getKey(), oldLines));
            List<String> newLines = classPath.formatAll(x.getKey(), this.generateDelegates(x.getValue()));
            classPath.writeLinesByService(ServiceProviderProcessor.merge(oldLines, newLines), x.getKey());
        }
    }

    private List<ProviderRef> generateDelegates(List<ProviderRef> refs) {
        for (ProviderRef ref : refs) {
            if (!Instantiator.allOf(this.processingEnv.getTypeUtils(), ref.getService(), ref.getProvider()).stream().anyMatch(o -> o.getKind() == Instantiator.Kind.STATIC_METHOD)) continue;
            this.error(ref, "Static method support not implemented yet");
        }
        return refs;
    }

    static List<String> merge(List<String> first, List<String> second) {
        ArrayList<String> result = new ArrayList<String>(first);
        second.stream().filter(element -> !result.contains(element)).forEach(result::add);
        return result;
    }
}

