/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.LhodDatabaseMetaData;
import internal.sql.lhod.LhodPreparedStatement;
import internal.sql.lhod.LhodStatement;
import internal.sql.lhod.TabDataExecutor;
import internal.sql.lhod.TabDataQuery;
import internal.sql.lhod.TabDataReader;
import internal.sql.lhod.TabDataRemoteError;
import internal.sql.lhod._Connection;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LhodConnection
extends _Connection {
    @NonNull
    private final TabDataExecutor executor;
    @NonNull
    private final String connectionString;
    private EnumMap<DynamicProperty, String> lazyProperties = null;
    static final List<String> DYNAMIC_PROPERTY_KEYS = Stream.of(DynamicProperty.values()).map(DynamicProperty::getKey).collect(Collectors.toList());

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.executor.isClosed();
        }
        catch (IOException ex) {
            throw new SQLException("Failed to check executor state", ex);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.executor.close();
        }
        catch (IOException ex) {
            throw new SQLException("Failed to close executor", ex);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkState();
        return LhodDatabaseMetaData.of(this);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkState();
        try {
            return this.getProperty(DynamicProperty.CURRENT_CATALOG);
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format("Failed to get catalog name of '%s'", this.connectionString), ex);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkState();
        return null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkState();
        return LhodStatement.of(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkState();
        return LhodPreparedStatement.of(this, sql);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkState();
        return true;
    }

    @Nullable String getProperty(@org.checkerframework.checker.nullness.qual.NonNull DynamicProperty property) throws IOException {
        Objects.requireNonNull(property);
        if (this.lazyProperties == null) {
            this.lazyProperties = this.loadProperties();
        }
        return this.lazyProperties.get((Object)property);
    }

    @org.checkerframework.checker.nullness.qual.NonNull TabDataReader exec(@org.checkerframework.checker.nullness.qual.NonNull TabDataQuery query) throws IOException {
        return this.executor.exec(query);
    }

    private EnumMap<DynamicProperty, String> loadProperties() throws IOException {
        TabDataQuery query = TabDataQuery.builder().procedure("DbProperties").parameter(this.connectionString).parameters(DYNAMIC_PROPERTY_KEYS).build();
        try (TabDataReader reader = this.exec(query);){
            HashMap<String, String> properties = new HashMap<String, String>();
            while (reader.readNextRow()) {
                properties.put(reader.get(0), reader.get(1));
            }
            EnumMap<DynamicProperty, String> enumMap = this.getProperties(properties);
            return enumMap;
        }
    }

    private EnumMap<DynamicProperty, String> getProperties(Map<String, String> properties) {
        EnumMap<DynamicProperty, String> result = new EnumMap<DynamicProperty, String>(DynamicProperty.class);
        for (DynamicProperty o : DynamicProperty.values()) {
            String value = properties.get(o.getKey());
            if (value == null) continue;
            result.put(o, value);
        }
        return result;
    }

    void checkState() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(String.format("Connection '%s' closed", this.connectionString));
        }
    }

    private LhodConnection(@NonNull TabDataExecutor executor, @NonNull String connectionString) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (connectionString == null) {
            throw new NullPointerException("connectionString is marked non-null but is null");
        }
        this.executor = executor;
        this.connectionString = connectionString;
    }

    public static LhodConnection of(@NonNull TabDataExecutor executor, @NonNull String connectionString) {
        return new LhodConnection(executor, connectionString);
    }

    @NonNull
    public String getConnectionString() {
        return this.connectionString;
    }

    static enum DynamicProperty {
        CURRENT_CATALOG("Current Catalog"),
        SPECIAL_CHARACTERS("Special Characters"),
        IDENTIFIER_CASE_SENSITIVITY("Identifier Case Sensitivity"),
        STRING_FUNCTIONS("String Functions");

        private final String key;

        private DynamicProperty(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

