/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.picocsv;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;

public final class Csv {
    public static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;

    private Csv() {
    }

    private static RuntimeException newUnreachable() {
        return new RuntimeException("Unreachable");
    }

    private static void requireArgument(boolean condition, String format, Object arg) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(String.format(format, arg));
        }
    }

    private static int hashCodeOf(boolean value) {
        return value ? 1231 : 1237;
    }

    private static String prettyPrint(String text) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            result.append(Csv.prettyPrint(text.charAt(i)));
        }
        return result.toString();
    }

    private static String prettyPrint(char c) {
        switch (c) {
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    public static final class Writer
    implements Closeable {
        private final Output output;
        private final char quote;
        private final char delimiter;
        private final EndOfLineEncoder eolEncoder;
        private int state = 0;
        private static final int QUOTING_NONE = 0;
        private static final int QUOTING_PARTIAL = 1;
        private static final int QUOTING_FULL = 2;
        private static final int STATE_NO_FIELD = 0;
        private static final int STATE_SINGLE_EMPTY_FIELD = 1;
        private static final int STATE_MULTI_FIELD = 2;

        public static Writer of(Format format, WriterOptions options, java.io.Writer charWriter, int charBufferSize) throws IllegalArgumentException, IOException {
            Objects.requireNonNull(format, "format");
            Objects.requireNonNull(options, "options");
            Objects.requireNonNull(charWriter, "charWriter");
            Csv.requireArgument(charBufferSize > 0, "Invalid charBufferSize: %s", charBufferSize);
            Csv.requireArgument(format.isValid(), "Invalid format: %s", format);
            return new Writer(new Output(charWriter, new char[charBufferSize]), format.getQuote(), format.getDelimiter(), EndOfLineEncoder.of(format));
        }

        private Writer(Output output, char quote, char delimiter, EndOfLineEncoder eolEncoder) {
            this.output = output;
            this.quote = quote;
            this.delimiter = delimiter;
            this.eolEncoder = eolEncoder;
        }

        public void writeField(CharSequence field) throws IOException {
            switch (this.state) {
                case 0: {
                    if (this.isNotEmpty(field)) {
                        this.state = 2;
                        this.writeNonEmptyField(field);
                        break;
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.state = 2;
                    this.output.write(this.delimiter);
                    if (!this.isNotEmpty(field)) break;
                    this.writeNonEmptyField(field);
                    break;
                }
                case 2: {
                    this.output.write(this.delimiter);
                    if (!this.isNotEmpty(field)) break;
                    this.writeNonEmptyField(field);
                }
            }
        }

        public void writeEndOfLine() throws IOException {
            this.flushField();
            this.eolEncoder.write(this.output);
        }

        @Override
        public void close() throws IOException {
            this.flushField();
            this.output.close();
        }

        private boolean isNotEmpty(CharSequence field) {
            return field != null && field.length() != 0;
        }

        private void writeNonEmptyField(CharSequence field) throws IOException {
            switch (this.getQuoting(field)) {
                case 0: {
                    this.output.write(field);
                    break;
                }
                case 1: {
                    this.output.write(this.quote);
                    this.output.write(field);
                    this.output.write(this.quote);
                    break;
                }
                case 2: {
                    this.output.write(this.quote);
                    for (int i = 0; i < field.length(); ++i) {
                        char c = field.charAt(i);
                        if (c == this.quote) {
                            this.output.write(c);
                        }
                        this.output.write(c);
                    }
                    this.output.write(this.quote);
                }
            }
        }

        private void flushField() throws IOException {
            if (this.state == 1) {
                this.output.write(this.quote);
                this.output.write(this.quote);
            }
            this.state = 0;
        }

        private int getQuoting(CharSequence field) {
            int result = 0;
            for (int i = 0; i < field.length(); ++i) {
                char c = field.charAt(i);
                if (c == this.quote) {
                    return 2;
                }
                if (c != this.delimiter && !this.eolEncoder.isNewLine(c)) continue;
                result = 1;
            }
            return result;
        }

        private static final class Output
        implements Closeable {
            private final java.io.Writer charWriter;
            private final char[] buffer;
            private int length = 0;

            private Output(java.io.Writer charWriter, char[] charBuffer) {
                this.charWriter = charWriter;
                this.buffer = charBuffer;
            }

            public void write(char c) throws IOException {
                if (this.length == this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.length++] = c;
            }

            public void write(CharSequence chars) throws IOException {
                int charsLength = chars.length();
                if (this.length + charsLength >= this.buffer.length) {
                    this.flush();
                    if (charsLength >= this.buffer.length) {
                        this.charWriter.append(chars);
                        return;
                    }
                }
                if (chars instanceof String) {
                    ((String)chars).getChars(0, charsLength, this.buffer, this.length);
                    this.length += charsLength;
                } else {
                    for (int i = 0; i < charsLength; ++i) {
                        this.buffer[this.length++] = chars.charAt(i);
                    }
                }
            }

            @Override
            public void close() throws IOException {
                this.flush();
                this.charWriter.close();
            }

            private void flush() throws IOException {
                this.charWriter.write(this.buffer, 0, this.length);
                this.length = 0;
            }
        }

        private static abstract class EndOfLineEncoder {
            private EndOfLineEncoder() {
            }

            public abstract void write(Output var1) throws IOException;

            public abstract boolean isNewLine(char var1);

            public static EndOfLineEncoder of(Format format) {
                String eol = format.getSeparator();
                switch (eol.length()) {
                    case 1: {
                        return new SingleEncoder(eol.charAt(0));
                    }
                    case 2: {
                        return new DualEncoder(eol.charAt(0), eol.charAt(1));
                    }
                }
                throw Csv.newUnreachable();
            }

            private static final class SingleEncoder
            extends EndOfLineEncoder {
                private final char single;

                private SingleEncoder(char single) {
                    this.single = single;
                }

                @Override
                public void write(Output output) throws IOException {
                    output.write(this.single);
                }

                @Override
                public boolean isNewLine(char c) {
                    return c == this.single;
                }
            }

            private static final class DualEncoder
            extends EndOfLineEncoder {
                private final char first;
                private final char second;

                private DualEncoder(char first, char second) {
                    this.first = first;
                    this.second = second;
                }

                @Override
                public void write(Output output) throws IOException {
                    output.write(this.first);
                    output.write(this.second);
                }

                @Override
                public boolean isNewLine(char c) {
                    return c == this.first || c == this.second;
                }
            }
        }
    }

    public static final class WriterOptions {
        public static final WriterOptions DEFAULT = new WriterOptions();

        private WriterOptions() {
        }

        public int hashCode() {
            int hash = 7;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WriterOptions other = (WriterOptions)obj;
            return true;
        }

        public String toString() {
            return "WriterOptions()";
        }

        public Builder toBuilder() {
            return new Builder();
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        public static final class Builder {
            private Builder() {
            }

            public WriterOptions build() {
                return new WriterOptions();
            }
        }
    }

    public static final class Reader
    implements Closeable,
    CharSequence {
        private final Input input;
        private final int quoteCode;
        private final int delimiterCode;
        private final EndOfLineDecoder eolDecoder;
        private final char[] fieldChars;
        private int fieldLength = 0;
        private boolean fieldQuoted = false;
        private int state = 0;
        private boolean parsedByLine = false;
        private static final int STATE_READY = 0;
        private static final int STATE_NOT_LAST = 1;
        private static final int STATE_LAST = 2;
        private static final int STATE_DONE = 3;

        public static Reader of(Format format, ReaderOptions options, java.io.Reader charReader, int charBufferSize) throws IllegalArgumentException, IOException {
            Objects.requireNonNull(format, "format");
            Objects.requireNonNull(options, "options");
            Objects.requireNonNull(charReader, "charReader");
            Csv.requireArgument(charBufferSize > 0, "Invalid charBufferSize: %s", charBufferSize);
            Csv.requireArgument(format.isValid(), "Invalid format: %s", format);
            Csv.requireArgument(options.isValid(), "Invalid options: %s", options);
            char[] charBuffer = new char[charBufferSize];
            return new Reader(ReadAheadInput.isNeeded(format, options) ? new ReadAheadInput(charReader, charBuffer) : new Input(charReader, charBuffer), format.getQuote(), format.getDelimiter(), EndOfLineDecoder.of(format, options), new char[options.getMaxCharsPerField()]);
        }

        private Reader(Input input, int quoteCode, int delimiterCode, EndOfLineDecoder eolDecoder, char[] fieldChars) {
            this.input = input;
            this.quoteCode = quoteCode;
            this.delimiterCode = delimiterCode;
            this.eolDecoder = eolDecoder;
            this.fieldChars = fieldChars;
        }

        public boolean readLine() throws IOException {
            switch (this.state) {
                case 3: {
                    return false;
                }
                case 0: 
                case 2: {
                    this.parseNextField();
                    this.parsedByLine = true;
                    return this.state != 3;
                }
                case 1: {
                    this.skipRemainingFields();
                    this.parseNextField();
                    this.parsedByLine = true;
                    return this.state != 3;
                }
            }
            throw Csv.newUnreachable();
        }

        public boolean readField() throws IOException {
            switch (this.state) {
                case 2: {
                    if (this.parsedByLine) {
                        this.parsedByLine = false;
                        return this.isFieldNotNull();
                    }
                    return false;
                }
                case 1: {
                    if (this.parsedByLine) {
                        this.parsedByLine = false;
                        return true;
                    }
                    this.parseNextField();
                    return true;
                }
                case 3: {
                    return false;
                }
                case 0: {
                    throw new IllegalStateException();
                }
            }
            throw Csv.newUnreachable();
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        private void skipRemainingFields() throws IOException {
            do {
                this.parseNextField();
            } while (this.state == 1);
        }

        private void parseNextField() throws IOException {
            int fieldLength = this.fieldLength;
            boolean fieldQuoted = this.fieldQuoted;
            int state = this.state;
            try {
                int quoteCode = this.quoteCode;
                int delimiterCode = this.delimiterCode;
                char[] fieldChars = this.fieldChars;
                fieldLength = 0;
                fieldQuoted = false;
                int code = this.input.read();
                if (code != -1) {
                    if (code == quoteCode) {
                        fieldQuoted = true;
                    } else {
                        if (code == delimiterCode) {
                            state = 1;
                            return;
                        }
                        if (this.eolDecoder.isEndOfLine(code, this.input)) {
                            state = 2;
                            return;
                        }
                        fieldChars[fieldLength++] = (char)code;
                    }
                } else {
                    state = 3;
                    return;
                }
                if (fieldQuoted) {
                    boolean escaped = false;
                    while ((code = this.input.read()) != -1) {
                        if (code == quoteCode) {
                            if (!escaped) {
                                escaped = true;
                                continue;
                            }
                            escaped = false;
                            fieldChars[fieldLength++] = (char)code;
                            continue;
                        }
                        if (escaped) {
                            if (code == delimiterCode) {
                                state = 1;
                                return;
                            }
                            if (this.eolDecoder.isEndOfLine(code, this.input)) {
                                state = 2;
                                return;
                            }
                        }
                        fieldChars[fieldLength++] = (char)code;
                    }
                    state = 2;
                    return;
                }
                while ((code = this.input.read()) != -1) {
                    if (code == delimiterCode) {
                        state = 1;
                        return;
                    }
                    if (this.eolDecoder.isEndOfLine(code, this.input)) {
                        state = 2;
                        return;
                    }
                    fieldChars[fieldLength++] = (char)code;
                }
                state = fieldLength > 0 ? 2 : 3;
                return;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IOException("Field overflow", ex);
            }
            finally {
                this.fieldLength = fieldLength;
                this.fieldQuoted = fieldQuoted;
                this.state = state;
            }
        }

        private boolean isFieldNotNull() {
            return this.fieldLength > 0 || this.fieldQuoted;
        }

        @Override
        public String toString() {
            return this.fieldLength == 0 ? "" : new String(this.fieldChars, 0, this.fieldLength);
        }

        @Override
        public int length() {
            return this.fieldLength;
        }

        @Override
        public char charAt(int index) {
            if (index >= this.fieldLength) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.fieldChars[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end > this.fieldLength) {
                throw new IndexOutOfBoundsException(String.valueOf(end));
            }
            return new String(this.fieldChars, start, end - start);
        }

        private static final class ReadAheadInput
        extends Input {
            private static final int NULL_CODE = -2;
            private int readAheadCode = -2;

            static boolean isNeeded(Format format, ReaderOptions options) {
                return options.isLenientSeparator() || format.getSeparator().length() > 1;
            }

            private ReadAheadInput(java.io.Reader charReader, char[] charBuffer) {
                super(charReader, charBuffer);
            }

            @Override
            public int read() throws IOException {
                if (this.readAheadCode == -2) {
                    return super.read();
                }
                int result = this.readAheadCode;
                this.readAheadCode = -2;
                return result;
            }

            public boolean peek(int expected) throws IOException {
                this.readAheadCode = super.read();
                return this.readAheadCode == expected;
            }

            public void discardAheadOfTimeCode() {
                this.readAheadCode = -2;
            }
        }

        private static class Input
        implements Closeable {
            public static final int EOF_CODE = -1;
            private final java.io.Reader charReader;
            private final char[] buffer;
            private int length = 0;
            private int index = 0;

            private Input(java.io.Reader charReader, char[] charBuffer) {
                this.charReader = charReader;
                this.buffer = charBuffer;
            }

            @Override
            public void close() throws IOException {
                this.charReader.close();
            }

            public int read() throws IOException {
                int n;
                if (this.index < this.length) {
                    n = this.buffer[this.index++];
                } else {
                    this.length = this.charReader.read(this.buffer);
                    if (this.length == -1) {
                        n = -1;
                    } else {
                        this.index = 1;
                        n = this.buffer[1 - 1];
                    }
                }
                return n;
            }
        }

        private static abstract class EndOfLineDecoder {
            private EndOfLineDecoder() {
            }

            public abstract boolean isEndOfLine(int var1, Input var2) throws IOException;

            public static EndOfLineDecoder of(Format format, ReaderOptions options) {
                String eol = format.getSeparator();
                switch (eol.length()) {
                    case 1: {
                        return new SingleDecoder(eol.charAt(0));
                    }
                    case 2: {
                        return options.isLenientSeparator() ? new LenientDecoder(eol.charAt(0), eol.charAt(1)) : new DualDecoder(eol.charAt(0), eol.charAt(1));
                    }
                }
                throw Csv.newUnreachable();
            }

            private static final class SingleDecoder
            extends EndOfLineDecoder {
                private final int single;

                private SingleDecoder(int single) {
                    this.single = single;
                }

                @Override
                public boolean isEndOfLine(int code, Input input) {
                    return code == this.single;
                }
            }

            private static final class LenientDecoder
            extends EndOfLineDecoder {
                private final int first;
                private final int second;

                private LenientDecoder(int first, int second) {
                    this.first = first;
                    this.second = second;
                }

                @Override
                public boolean isEndOfLine(int code, Input input) throws IOException {
                    if (code == this.first) {
                        if (((ReadAheadInput)input).peek(this.second)) {
                            ((ReadAheadInput)input).discardAheadOfTimeCode();
                        }
                        return true;
                    }
                    return code == this.second;
                }
            }

            private static final class DualDecoder
            extends EndOfLineDecoder {
                private final int first;
                private final int second;

                private DualDecoder(int first, int second) {
                    this.first = first;
                    this.second = second;
                }

                @Override
                public boolean isEndOfLine(int code, Input input) throws IOException {
                    if (code == this.first && ((ReadAheadInput)input).peek(this.second)) {
                        ((ReadAheadInput)input).discardAheadOfTimeCode();
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    public static final class ReaderOptions {
        private static final boolean DEFAULT_LENIENT_SEPARATOR = false;
        private static final int DEFAULT_MAX_CHARS_PER_FIELD = 4096;
        public static final ReaderOptions DEFAULT = new ReaderOptions(false, 4096);
        private final boolean lenientSeparator;
        private final int maxCharsPerField;

        private ReaderOptions(boolean lenientSeparator, int maxCharsPerField) {
            this.lenientSeparator = lenientSeparator;
            this.maxCharsPerField = maxCharsPerField;
        }

        public boolean isLenientSeparator() {
            return this.lenientSeparator;
        }

        public int getMaxCharsPerField() {
            return this.maxCharsPerField;
        }

        public boolean isValid() {
            return this.maxCharsPerField > 0;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Csv.hashCodeOf(this.lenientSeparator);
            hash = 37 * hash + this.maxCharsPerField;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReaderOptions other = (ReaderOptions)obj;
            if (this.lenientSeparator != other.lenientSeparator) {
                return false;
            }
            return this.maxCharsPerField == other.maxCharsPerField;
        }

        public String toString() {
            return "ReaderOptions(lenientSeparator=" + this.lenientSeparator + ", maxCharsPerField=" + this.maxCharsPerField + ')';
        }

        public Builder toBuilder() {
            return new Builder().lenientSeparator(this.lenientSeparator).maxCharsPerField(this.maxCharsPerField);
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        public static final class Builder {
            private boolean lenientSeparator;
            private int maxCharsPerField;

            private Builder() {
            }

            public Builder lenientSeparator(boolean lenientSeparator) {
                this.lenientSeparator = lenientSeparator;
                return this;
            }

            public Builder maxCharsPerField(int maxCharsPerField) {
                this.maxCharsPerField = maxCharsPerField;
                return this;
            }

            public ReaderOptions build() {
                return new ReaderOptions(this.lenientSeparator, this.maxCharsPerField);
            }
        }
    }

    public static final class Format {
        public static final String WINDOWS_SEPARATOR = "\r\n";
        public static final String UNIX_SEPARATOR = "\n";
        public static final String MACINTOSH_SEPARATOR = "\r";
        private static final String DEFAULT_SEPARATOR = "\r\n";
        private static final char DEFAULT_DELIMITER = ',';
        private static final char DEFAULT_QUOTE = '\"';
        public static final Format RFC4180;
        public static final Format DEFAULT;
        private final String separator;
        private final char delimiter;
        private final char quote;

        private Format(String separator, char delimiter, char quote) {
            this.separator = Objects.requireNonNull(separator, "separator");
            this.delimiter = delimiter;
            this.quote = quote;
        }

        public String getSeparator() {
            return this.separator;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public char getQuote() {
            return this.quote;
        }

        public boolean isValid() {
            return Format.hasValidSize(this.separator) && this.delimiter != this.quote && Format.doesNotContain(this.separator, this.delimiter) && Format.doesNotContain(this.separator, this.quote);
        }

        private static boolean hasValidSize(String text) {
            int length = text.length();
            return 1 <= length && length < 3;
        }

        private static boolean doesNotContain(String text, char c) {
            return text.indexOf(c) == -1;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.separator);
            hash = 37 * hash + this.delimiter;
            hash = 37 * hash + this.quote;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Format other = (Format)obj;
            if (!this.separator.equals(other.separator)) {
                return false;
            }
            if (this.delimiter != other.delimiter) {
                return false;
            }
            return this.quote == other.quote;
        }

        public String toString() {
            return "Format(separator=" + Csv.prettyPrint(this.separator) + ", delimiter=" + Csv.prettyPrint(this.delimiter) + ", quote=" + Csv.prettyPrint(this.quote) + ')';
        }

        public Builder toBuilder() {
            return new Builder().separator(this.separator).delimiter(this.delimiter).quote(this.quote);
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        static {
            DEFAULT = RFC4180 = new Format("\r\n", ',', '\"');
        }

        public static final class Builder {
            private String separator;
            private char delimiter;
            private char quote;

            private Builder() {
            }

            public Builder separator(String separator) {
                this.separator = separator;
                return this;
            }

            public Builder delimiter(char delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Builder quote(char quote) {
                this.quote = quote;
                return this;
            }

            public Format build() {
                return new Format(this.separator, this.delimiter, this.quote);
            }
        }
    }
}

