/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.LhodConnection;
import internal.sql.lhod.TabDataEngine;
import internal.sql.lhod.VbsEngine;
import internal.sql.lhod._Driver;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;

public final class LhodDriver
extends _Driver {
    @Generated
    private static final Logger log = Logger.getLogger(LhodDriver.class.getName());
    public static final String PREFIX = "jdbc:lhod:";
    @NonNull
    private final TabDataEngine engine;

    public LhodDriver() {
        this(new VbsEngine());
    }

    LhodDriver(TabDataEngine engine) {
        this.engine = engine;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            return LhodConnection.of(this.engine.getExecutor(), this.getConnectionString(url));
        }
        catch (IOException ex) {
            throw new SQLException(String.format("Cannot instantiate executor: '%s'", url), ex);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("URL cannot be null");
        }
        return url.toLowerCase().startsWith(PREFIX);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    private String getConnectionString(String url) {
        return url.trim().substring(PREFIX.length());
    }

    static {
        try {
            DriverManager.registerDriver(new LhodDriver());
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "Cannot register AdoDriver", ex);
        }
    }
}

