/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.LhodConnection;
import internal.sql.lhod.LhodResultSet;
import internal.sql.lhod.TabDataQuery;
import internal.sql.lhod.TabDataRemoteError;
import internal.sql.lhod._PreparedStatement;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

final class LhodPreparedStatement
extends _PreparedStatement {
    @lombok.NonNull
    private final LhodConnection conn;
    @lombok.NonNull
    private final String sql;
    private final Map<Integer, String> parameters = new HashMap<Integer, String>();
    private boolean closed = false;

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkState();
        TabDataQuery query = TabDataQuery.builder().procedure("PreparedStatement").parameter(this.conn.getConnectionString()).parameter(this.sql).parameters(this.getParameterList()).build();
        try {
            return LhodResultSet.of(this.conn.exec(query));
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format("Failed to execute query '%s'", this.sql), ex);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkState();
        this.chechParameterIndex(parameterIndex);
        this.parameters.put(parameterIndex, x);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkState();
        return this.conn;
    }

    List<String> getParameterList() {
        return this.parameters.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void checkState() throws SQLException {
        this.conn.checkState();
        if (this.closed) {
            throw new SQLException("PreparedStatement closed");
        }
    }

    private void chechParameterIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1) {
            throw new SQLException("Parameter index out of bounds: " + parameterIndex);
        }
    }

    @Generated
    private LhodPreparedStatement(@lombok.NonNull LhodConnection conn, @lombok.NonNull String sql) {
        if (conn == null) {
            throw new NullPointerException("conn is marked non-null but is null");
        }
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        this.conn = conn;
        this.sql = sql;
    }

    @Generated
    public static @NonNull LhodPreparedStatement of(@lombok.NonNull LhodConnection conn, @lombok.NonNull String sql) {
        return new LhodPreparedStatement(conn, sql);
    }
}

