/*
 * Decompiled with CFR 0.152.
 */
package org.api.manapool.model;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Date;
import org.api.manapool.model.ProductItem;
import org.api.manapool.model.enums.EnumType;
import org.api.manapool.services.ManaPoolAPIService;

public class InventoryItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    @SerializedName(value="price_cents")
    private Integer priceCents;
    private Integer quantity;
    @SerializedName(value="effective_as_of")
    private String effectiveAsOf;
    @SerializedName(value="product_type")
    private EnumType type;
    @SerializedName(value="product_id")
    private String productId;
    private ProductItem product;

    public double getPriceValue() {
        return (double)this.getPriceCents().intValue() / 100.0;
    }

    public Date getDateffectiveAsOf() {
        return ManaPoolAPIService.parseDate(this.effectiveAsOf);
    }

    public String toString() {
        return this.getId();
    }

    public EnumType getType() {
        return this.type;
    }

    public void setType(EnumType type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getPriceCents() {
        return this.priceCents;
    }

    public void setPriceCents(Integer priceCents) {
        this.priceCents = priceCents;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getEffectiveAsOf() {
        return this.effectiveAsOf;
    }

    public void setEffectiveAsOf(String effectiveAsOf) {
        this.effectiveAsOf = effectiveAsOf;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public ProductItem getProduct() {
        return this.product;
    }

    public void setProduct(ProductItem product) {
        this.product = product;
    }
}

