/*
 * Decompiled with CFR 0.152.
 */
package org.api.manapool.services;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import org.api.manapool.model.InventoryEntry;
import org.api.manapool.model.InventoryItems;
import org.api.manapool.model.ProductQueryEntry;
import org.api.manapool.tools.RestClient;

public class InventoryService {
    private RestClient client;

    public InventoryService(String email, String token) {
        this.client = new RestClient(email, token);
    }

    public List<InventoryEntry> getSellerInventory() throws IOException {
        return this.client.get("/seller/inventory", null, InventoryItems.class).getInventory();
    }

    public List<InventoryEntry> getSellerInventory(int limit, int offset) throws IOException {
        return this.client.get("/seller/inventory?limit=" + limit + "&offset=" + offset, null, InventoryItems.class).getInventory();
    }

    public List<InventoryEntry> addInventoryItems(List<ProductQueryEntry> inventoryList) throws IOException {
        return this.client.post("/seller/inventory/scryfall_id", inventoryList, null, InventoryItems.class).getInventory();
    }

    public InventoryEntry updateInventoryItems(ProductQueryEntry item) throws IOException {
        JsonObject obj = this.client.put("/seller/inventory/scryfall_id/" + item.getScryfallId() + "?language_id=" + String.valueOf((Object)item.getLanguage()) + "&finish_id=" + String.valueOf((Object)item.getFinishId()) + "&condition_id=" + String.valueOf((Object)item.getCondition()), item, null, JsonObject.class);
        return this.client.fromJson(obj.get("inventory").getAsJsonObject().toString(), InventoryEntry.class);
    }

    public InventoryEntry deleteInventoryItems(ProductQueryEntry item) throws IOException {
        JsonObject obj = this.client.delete("/seller/inventory/scryfall_id/" + item.getScryfallId() + "?language_id=" + String.valueOf((Object)item.getLanguage()) + "&finish_id=" + String.valueOf((Object)item.getFinishId()) + "&condition_id=" + String.valueOf((Object)item.getCondition()), item, null, JsonObject.class);
        return this.client.fromJson(obj.get("inventory").getAsJsonObject().toString(), InventoryEntry.class);
    }
}

