/*
 * Decompiled with CFR 0.152.
 */
package org.api.manapool.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.api.manapool.model.Account;
import org.api.manapool.model.Card;
import org.api.manapool.model.Inventory;
import org.api.manapool.model.InventoryItem;
import org.api.manapool.model.Order;
import org.api.manapool.model.OrderSummary;
import org.api.manapool.model.PriceVariation;
import org.api.manapool.model.Product;
import org.api.manapool.model.ProductQueryEntry;
import org.api.manapool.tools.RestClient;

public class ManaPoolAPIService {
    private RestClient client;
    protected static Logger logger = LogManager.getLogger(ManaPoolAPIService.class);

    public ManaPoolAPIService(String email, String token) {
        this.client = new RestClient(email, token);
    }

    public ManaPoolAPIService(File f) throws IOException {
        Properties p = new Properties();
        try (FileReader read = new FileReader(f);){
            p.load(read);
            this.client = new RestClient(p.getProperty("EMAIL"), p.getProperty("TOKEN"));
        }
    }

    public RestClient getClient() {
        return this.client;
    }

    public Card cardInfo(String cardName) throws IOException {
        try {
            return this.cardInfo(List.of(cardName)).getFirst();
        }
        catch (NoSuchElementException e) {
            logger.error("No results found for {}", (Object)cardName, (Object)e);
            return null;
        }
    }

    public List<Card> cardInfo(List<String> cardNames) throws IOException {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        obj.add("card_names", (JsonElement)arr);
        cardNames.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
        JsonArray ret = this.client.post("/card_info", obj, null, JsonObject.class).get("cards").getAsJsonArray();
        return ret.asList().stream().map(e -> this.client.fromJson(e.toString(), Card.class)).toList();
    }

    public Inventory getSellerInventory() throws IOException {
        Inventory inventory = this.client.get("/seller/inventory", null, Inventory.class);
        return this.getSellerInventory(inventory.getPagination().getTotal(), 0);
    }

    public Inventory getSellerInventory(int limit, int offset) throws IOException {
        return this.client.get("/seller/inventory?limit=" + limit + "&offset=" + offset, null, Inventory.class);
    }

    public Inventory addInventoryItems(List<ProductQueryEntry> inventoryList) throws IOException {
        return this.client.post("/seller/inventory/scryfall_id", inventoryList, null, Inventory.class);
    }

    public InventoryItem updateInventoryItems(ProductQueryEntry item) throws IOException {
        JsonObject obj = this.client.put("/seller/inventory/scryfall_id/" + item.getScryfallId() + "?language_id=" + String.valueOf((Object)item.getLanguage()) + "&finish_id=" + String.valueOf((Object)item.getFinishId()) + "&condition_id=" + String.valueOf((Object)item.getCondition()), item, null, JsonObject.class);
        return this.client.fromJson(obj.get("inventory").getAsJsonObject().toString(), InventoryItem.class);
    }

    public InventoryItem deleteInventoryItems(ProductQueryEntry item) throws IOException {
        JsonObject obj = this.client.delete("/seller/inventory/scryfall_id/" + item.getScryfallId() + "?language_id=" + String.valueOf((Object)item.getLanguage()) + "&finish_id=" + String.valueOf((Object)item.getFinishId()) + "&condition_id=" + String.valueOf((Object)item.getCondition()), item, null, JsonObject.class);
        return this.client.fromJson(obj.get("inventory").getAsJsonObject().toString(), InventoryItem.class);
    }

    public InventoryItem deleteInventoryItems(Product item) throws IOException {
        JsonObject obj = this.client.delete("/seller/inventory/scryfall_id/" + item.getScryfallId() + "?language_id=" + String.valueOf((Object)item.getLanguage()) + "&finish_id=" + String.valueOf((Object)item.getFinishId()) + "&condition_id=" + String.valueOf((Object)item.getCondition()), item, null, JsonObject.class);
        return this.client.fromJson(obj.get("inventory").getAsJsonObject().toString(), InventoryItem.class);
    }

    public List<PriceVariation> listSinglesPrices() throws IOException {
        JsonArray arr = this.client.get("/prices/singles", null, JsonObject.class).get("data").getAsJsonArray();
        return arr.asList().stream().map(e -> this.client.fromJson(e.toString(), PriceVariation.class)).toList();
    }

    public List<PriceVariation> listSealedPrices() throws IOException {
        JsonArray arr = this.client.get("/prices/sealed", null, JsonObject.class).get("data").getAsJsonArray();
        return arr.asList().stream().map(e -> this.client.fromJson(e.toString(), PriceVariation.class)).toList();
    }

    public List<PriceVariation> listVariantsPrices() throws IOException {
        JsonArray arr = this.client.get("/prices/variants", null, JsonObject.class).get("data").getAsJsonArray();
        return arr.asList().stream().map(e -> this.client.fromJson(e.toString(), PriceVariation.class)).toList();
    }

    public List<OrderSummary> listSellsOrders(int limit, int offset) throws IOException {
        JsonArray arr = this.client.get("/seller/orders?limit=" + limit + "&offset=" + offset, null, JsonObject.class).get("orders").getAsJsonArray();
        return arr.asList().stream().map(e -> this.client.fromJson(e.toString(), OrderSummary.class)).toList();
    }

    public List<OrderSummary> listBoughtOrders(int limit, int offset) throws IOException {
        JsonArray arr = this.client.get("/buyer/orders?limit=" + limit + "&offset=" + offset, null, JsonObject.class).get("orders").getAsJsonArray();
        return arr.asList().stream().map(e -> this.client.fromJson(e.toString(), OrderSummary.class)).toList();
    }

    public void clearSellerInventory() throws IOException {
        this.getSellerInventory().forEach(item -> {
            try {
                this.deleteInventoryItems(item.getProduct().getSingle());
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        });
    }

    public Order getSellsOrder(OrderSummary os) throws IOException {
        return this.getSellsOrderById(os.getId());
    }

    public Order getBoughtOrderById(String id) throws IOException {
        return this.client.get("/buyer/orders/" + id, null, Order.class);
    }

    public Order getBoughtOrder(OrderSummary os) throws IOException {
        return this.getSellsOrderById(os.getId());
    }

    public Order getSellsOrderById(String id) throws IOException {
        return this.client.get("/seller/orders/" + id, null, Order.class);
    }

    public double userCredits() throws IOException {
        int arr = this.client.get("/buyer/credit", null, JsonObject.class).get("user_credit_cents").getAsInt();
        return (double)arr / 100.0;
    }

    public Account userAccount() throws IOException {
        return this.client.get("/account", null, Account.class);
    }

    public static Date parseDate(String date) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ").parse(date);
        }
        catch (ParseException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static String toDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ").format(date);
    }
}

