/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.api.mkm.modele.Expansion;
import org.api.mkm.modele.Game;
import org.api.mkm.modele.Link;
import org.api.mkm.modele.Localization;
import org.api.mkm.modele.Product;
import org.api.mkm.modele.Response;
import org.api.mkm.tools.Tools;

public class ProductServices {
    private XStream xstream;
    private Logger logger = LogManager.getLogger(this.getClass());
    public static final String ENGLISH = "1";
    public static final String FRENCH = "2";
    public static final String GERMAN = "3";
    public static final String SPANISH = "4";
    public static final String ITALIAN = "5";

    public static String[] getLangs() {
        return new String[]{"ENGLISH", "FRENCH", "GERMAN", "SPANISH", "ITALIAN"};
    }

    public ProductServices() {
        this.xstream = Tools.instNewXstream();
        this.xstream.addImplicitCollection(Response.class, "product", Product.class);
        this.xstream.addImplicitCollection(Response.class, "links", Link.class);
        this.xstream.addImplicitCollection(Response.class, "single", Product.class);
        this.xstream.addImplicitCollection(Response.class, "expansion", Expansion.class);
        this.xstream.addImplicitCollection(Product.class, "links", Link.class);
        this.xstream.addImplicitCollection(Product.class, "localization", Localization.class);
        this.xstream.addImplicitCollection(Product.class, "reprint", Expansion.class);
    }

    public void exportPriceGuide(File f, Game game) throws IOException {
        this.exportPriceGuide(f, game.getIdGame());
    }

    public void exportPriceGuide(File f, Integer idGame) throws IOException {
        Object link = "https://api.cardmarket.com/ws/v2.0/priceguide";
        if (idGame != null) {
            link = "https://api.cardmarket.com/ws/v2.0/priceguide?idGame=" + idGame;
        }
        String xml = Tools.getXMLResponse((String)link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        byte[] bytes = Base64.decodeBase64((String)res.getPriceguidefile());
        File temp = new File("mkm_temp.gz");
        FileUtils.writeByteArrayToFile((File)temp, (byte[])bytes);
        Tools.unzip(temp, f);
        if (!temp.delete()) {
            this.logger.error((Object)("couln't remove " + temp.getAbsolutePath()));
        }
    }

    public void exportProductList(File f) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/productlist";
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        byte[] bytes = Base64.decodeBase64((String)res.getProductsfile());
        File temp = new File("mkm_temp.gz");
        FileUtils.writeByteArrayToFile((File)temp, (byte[])bytes);
        Tools.unzip(temp, f);
        if (!temp.delete()) {
            this.logger.error((Object)("Couldn't remove " + temp.getAbsolutePath()));
        }
    }

    public List<Product> getProductByExpansion(Expansion e) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/expansions/" + e.getIdExpansion() + "/singles";
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        this.logger.debug((Object)("RESP=" + xml));
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getSingle();
    }

    public List<Product> loadProducts(File f) throws IOException {
        String xml = Files.readString(f.toPath());
        Response res = (Response)this.xstream.fromXML(xml);
        if (this.isEmpty(res.getProduct())) {
            return new ArrayList<Product>();
        }
        return res.getProduct();
    }

    public List<Product> findProduct(String name, Map<Product.PRODUCT_ATTS, String> atts) throws IOException {
        String xml;
        Response res;
        this.xstream.aliasField("expansion", Product.class, "expansionName");
        String link = "https://api.cardmarket.com/ws/v2.0/products/find?search=" + Tools.encodeString(name);
        if (atts != null && atts.size() > 0) {
            link = link + "&";
            ArrayList<CallSite> paramStrings = new ArrayList<CallSite>();
            for (Map.Entry<Product.PRODUCT_ATTS, String> parameter : atts.entrySet()) {
                paramStrings.add((CallSite)((Object)((Object)((Object)parameter.getKey()) + "=" + parameter.getValue())));
            }
            link = link + Tools.join(paramStrings, "&");
        }
        if (this.isEmpty((res = (Response)this.xstream.fromXML(xml = Tools.getXMLResponse(link, "GET", this.getClass()))).getProduct())) {
            return new ArrayList<Product>();
        }
        return res.getProduct();
    }

    public List<Product> findMetaProduct(String name, Map<Product.PRODUCT_ATTS, String> atts) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/products/find?search=" + Tools.encodeString(name);
        if (atts.size() > 0) {
            link = link + "&";
            ArrayList<CallSite> paramStrings = new ArrayList<CallSite>();
            for (Map.Entry<Product.PRODUCT_ATTS, String> parameter : atts.entrySet()) {
                paramStrings.add((CallSite)((Object)((Object)((Object)parameter.getKey()) + "=" + parameter.getValue())));
            }
            link = link + Tools.join(paramStrings, "&");
        }
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getProduct();
    }

    public Product getMetaProductById(int idMeta) throws IOException {
        this.xstream.aliasField("expansion", Product.class, "expansion");
        String xml = Tools.getXMLResponse("https://api.cardmarket.com/ws/v2.0/metaproducts/" + idMeta, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getProduct().get(0);
    }

    public Product getProductById(int idProduct) throws IOException {
        this.xstream.aliasField("expansion", Product.class, "expansion");
        String xml = Tools.getXMLResponse("https://api.cardmarket.com/ws/v2.0/products/" + idProduct, "GET", this.getClass());
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getProduct().get(0);
    }

    public void fusion(Product from, Product dest) {
        try {
            for (Map.Entry e : PropertyUtils.describe((Object)from).entrySet()) {
                if (e.getValue() == null || ((String)e.getKey()).equals("class")) continue;
                PropertyUtils.setProperty((Object)dest, (String)((String)e.getKey()), e.getValue());
            }
        }
        catch (Exception e1) {
            this.logger.error((Object)e1);
        }
    }

    private boolean isEmpty(List<Product> product) {
        return product.get(0).getIdProduct() == 0;
    }
}

