/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.api.mkm.exceptions.MkmException;
import org.api.mkm.exceptions.MkmNetworkException;
import org.api.mkm.modele.Link;
import org.api.mkm.modele.Response;
import org.api.mkm.modele.User;
import org.api.mkm.tools.MkmAPIConfig;
import org.api.mkm.tools.Tools;

public class AuthenticationServices {
    private String appToken;
    private String appSecret;
    private String accessToken;
    private String accessSecret;
    private XStream xstream;
    private Logger logger = LogManager.getLogger(this.getClass());

    public AuthenticationServices(String accessSecret, String accessToken, String appSecret, String appToken) throws MkmException {
        this.accessSecret = accessSecret;
        this.accessToken = accessToken;
        this.appSecret = appSecret;
        this.appToken = appToken;
        if (accessSecret == null || accessToken == null || appSecret == null || appToken == null) {
            throw new MkmException("API authentication field must be filled");
        }
        if (accessSecret.equals("") || accessToken.equals("") || appSecret.equals("") || appToken.equals("")) {
            throw new MkmException("API authentication field must be filled");
        }
        this.xstream = Tools.instNewXstream();
        this.xstream.addImplicitCollection(Response.class, "links", Link.class);
    }

    public User getAuthenticatedUser() throws IOException {
        boolean ret;
        String link = "https://api.cardmarket.com/ws/v2.0/account";
        HttpURLConnection connection = (HttpURLConnection)new URL(link).openConnection();
        connection.addRequestProperty("Authorization", this.generateOAuthSignature2(link, "GET"));
        connection.connect();
        this.logger.debug((Object)("LINK=" + link));
        MkmAPIConfig.getInstance().updateCount(connection);
        boolean bl = ret = connection.getResponseCode() >= 200 && connection.getResponseCode() < 300;
        if (!ret) {
            throw new MkmNetworkException(connection.getResponseCode());
        }
        String xml = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
        Response res = (Response)this.xstream.fromXML(xml);
        return res.getAccount();
    }

    private Map<String, String> parseQueryString(String query) {
        String[] querySegments;
        TreeMap<String, String> queryParameters = new TreeMap<String, String>();
        for (String segment : querySegments = query.split("&")) {
            String[] parts = segment.split("=");
            if (parts.length <= 0) continue;
            String key = parts[0].replaceAll("\\?", " ").trim();
            String val = parts[1].trim();
            queryParameters.put(key, val);
        }
        return queryParameters;
    }

    public String generateOAuthSignature2(String url, String method) throws MkmException {
        try {
            TreeMap<String, String> encodedParams = new TreeMap<String, String>();
            int index = url.indexOf(63);
            String signatureMethod = "HMAC-SHA1";
            String version = "1.0";
            String encode = "UTF-8";
            String nonce = "" + System.currentTimeMillis();
            String timestamp = "" + System.currentTimeMillis() / 1000L;
            String baseUri = index > 0 ? url.substring(0, index) : url;
            String signatureKey = URLEncoder.encode(this.appSecret, encode) + "&" + URLEncoder.encode(this.accessSecret, encode);
            TreeMap<String, String> headerParams = new TreeMap<String, String>();
            headerParams.put("oauth_consumer_key", this.appToken);
            headerParams.put("oauth_token", this.accessToken);
            headerParams.put("oauth_nonce", nonce);
            headerParams.put("oauth_timestamp", timestamp);
            headerParams.put("oauth_signature_method", signatureMethod);
            headerParams.put("oauth_version", version);
            headerParams.put("realm", baseUri);
            String baseString = method.toUpperCase() + "&" + URLEncoder.encode(baseUri, encode) + "&";
            this.logger.trace((Object)("baseString=" + baseString));
            if (index > 0) {
                String urlParams = url.substring(index + 1);
                Map<String, String> map = this.parseQueryString(urlParams);
                for (Map.Entry<String, String> k : map.entrySet()) {
                    headerParams.put(k.getKey(), k.getValue());
                    this.logger.trace((Object)("headerParams.put(" + k.getKey() + "," + k.getValue() + ")"));
                }
            }
            for (Map.Entry entry : headerParams.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("realm")) continue;
                encodedParams.put(URLEncoder.encode((String)entry.getKey(), encode), (String)entry.getValue());
                this.logger.trace((Object)("encodedParams.put(" + URLEncoder.encode((String)entry.getKey(), encode) + "," + (String)entry.getValue() + ")"));
            }
            ArrayList<String> paramStrings = new ArrayList<String>();
            for (Map.Entry entry : encodedParams.entrySet()) {
                paramStrings.add((String)entry.getKey() + "=" + (String)entry.getValue());
                this.logger.trace((Object)("paramStrings.add(" + (String)entry.getKey() + "=" + (String)entry.getValue() + ")"));
            }
            String string = URLEncoder.encode(Tools.join(paramStrings, "&"), encode).replaceAll("'", "%27");
            this.logger.trace((Object)("paramString=" + string));
            baseString = baseString + string;
            Mac mac = Mac.getInstance("HmacSHA1");
            SecretKeySpec secret = new SecretKeySpec(signatureKey.getBytes(), mac.getAlgorithm());
            mac.init(secret);
            byte[] digest = mac.doFinal(baseString.getBytes());
            String oAuthSignature = DatatypeConverter.printBase64Binary((byte[])digest);
            headerParams.put("oauth_signature", oAuthSignature);
            ArrayList<String> headerParamStrings = new ArrayList<String>();
            for (Map.Entry parameter : headerParams.entrySet()) {
                headerParamStrings.add((String)parameter.getKey() + "=\"" + (String)parameter.getValue() + "\"");
            }
            String authHeader = "OAuth " + Tools.join(headerParamStrings, ", ");
            this.logger.debug((Object)("authHeader=" + authHeader));
            return authHeader;
        }
        catch (Exception e) {
            throw new MkmException(e);
        }
    }
}

