/*
 * Decompiled with CFR 0.152.
 */
package org.mkm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.api.mkm.modele.WantItem;
import org.api.mkm.modele.Wantslist;
import org.api.mkm.services.ArticleService;
import org.api.mkm.services.WantsService;
import org.mkm.gui.WantListItemEditorPanel;
import org.mkm.gui.modeles.ArticlesTableModel;
import org.mkm.gui.modeles.WantListTableModel;

public class MkmWantListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JList<Wantslist> listResults;
    private JTable tableItemWl;
    private DefaultListModel<Wantslist> wantListModel;
    private WantListTableModel itemsTableModel;
    private ArticlesTableModel articlesTableModel;
    private Wantslist selected;
    private transient WantsService serviceW;
    private transient ArticleService serviceA;
    private JButton btnEditItem;
    private JButton btnRenameWl;
    private JButton btnDeleteWl;
    private transient Logger logger = LogManager.getLogger(this.getClass());

    private void initGUI() {
        this.serviceW = new WantsService();
        this.serviceA = new ArticleService();
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelNorth = new JPanel();
        this.add((Component)panelNorth, "North");
        JButton btnLoadWantlist = new JButton("Load WantList");
        btnLoadWantlist.addActionListener(ae -> this.loadWantList());
        panelNorth.add(btnLoadWantlist);
        JButton btnDelete = new JButton("Delete Item");
        btnDelete.setEnabled(false);
        btnDelete.addActionListener(ae -> {
            try {
                WantItem it = (WantItem)this.itemsTableModel.getValueAt(this.tableItemWl.getSelectedRow(), 0);
                this.selected = this.serviceW.deleteItem(this.selected, it);
                this.itemsTableModel.init(this.selected);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        });
        this.btnRenameWl = new JButton("Rename WL");
        this.btnRenameWl.setEnabled(false);
        this.btnRenameWl.addActionListener(ae -> {
            String res = JOptionPane.showInputDialog("New Name ?", (Object)this.selected.toString());
            try {
                this.serviceW.renameWantList(this.selected, res);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
            }
        });
        JButton btnCreateWl = new JButton("Create WL");
        btnCreateWl.addActionListener(ae -> {
            String name = JOptionPane.showInputDialog("Name ?");
            try {
                Wantslist l = this.serviceW.createWantList(name);
                this.wantListModel.addElement(l);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        });
        panelNorth.add(btnCreateWl);
        this.btnDeleteWl = new JButton("Delete WL");
        this.btnDeleteWl.setEnabled(false);
        this.btnDeleteWl.addActionListener(ae -> {
            if (this.selected == null) {
                JOptionPane.showMessageDialog(null, "Need to select a WantList", "ERROR", 0);
                return;
            }
            int res = JOptionPane.showConfirmDialog(null, "delete " + this.selected + " ?", "Confirmation", 0);
            if (res == 0) {
                try {
                    this.serviceW.deleteWantList(this.selected);
                    this.wantListModel.removeElement(this.selected);
                    this.selected = null;
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
                }
            }
        });
        panelNorth.add(this.btnDeleteWl);
        panelNorth.add(this.btnRenameWl);
        panelNorth.add(btnDelete);
        this.btnEditItem = new JButton("Edit");
        this.btnEditItem.setEnabled(false);
        this.btnEditItem.addActionListener(ae -> {
            try {
                WantItem it = (WantItem)this.itemsTableModel.getValueAt(this.tableItemWl.getSelectedRow(), 0);
                WantListItemEditorPanel dialog = new WantListItemEditorPanel(it);
                dialog.setVisible(true);
                if (dialog.getItem() != null) {
                    it = dialog.getItem();
                    this.serviceW.updateItem(this.selected, it);
                    this.loadWantList(this.selected);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        });
        panelNorth.add(this.btnEditItem);
        JPanel panelSouth = new JPanel();
        this.add((Component)panelSouth, "South");
        JScrollPane panelWest = new JScrollPane();
        this.add((Component)panelWest, "West");
        this.wantListModel = new DefaultListModel();
        this.listResults = new JList<Wantslist>(this.wantListModel);
        this.listResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                MkmWantListPanel.this.selected = (Wantslist)MkmWantListPanel.this.listResults.getSelectedValue();
                MkmWantListPanel.this.loadWantList(MkmWantListPanel.this.selected);
            }
        });
        panelWest.setViewportView(this.listResults);
        this.itemsTableModel = new WantListTableModel();
        this.articlesTableModel = new ArticlesTableModel();
        JSplitPane rightPanel = new JSplitPane();
        rightPanel.setOrientation(0);
        this.add((Component)rightPanel, "Center");
        JScrollPane scrollitems = new JScrollPane();
        rightPanel.setLeftComponent(scrollitems);
        this.tableItemWl = new JTable(this.itemsTableModel);
        this.tableItemWl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                MkmWantListPanel.this.btnEditItem.setEnabled(true);
                WantItem it = (WantItem)MkmWantListPanel.this.itemsTableModel.getValueAt(MkmWantListPanel.this.tableItemWl.rowAtPoint(me.getPoint()), 0);
                try {
                    MkmWantListPanel.this.articlesTableModel.init(MkmWantListPanel.this.serviceA.find(it.getProduct(), null));
                }
                catch (Exception e) {
                    MkmWantListPanel.this.logger.error((Object)e);
                }
            }
        });
        scrollitems.setViewportView(this.tableItemWl);
        JScrollPane scrollArticles = new JScrollPane();
        rightPanel.setRightComponent(scrollArticles);
        JTable tableArticles = new JTable(this.articlesTableModel);
        scrollArticles.setViewportView(tableArticles);
    }

    protected void loadWantList() {
        try {
            List<Wantslist> lists = this.serviceW.getWantList();
            for (Wantslist l : lists) {
                this.wantListModel.addElement(l);
            }
            this.btnDeleteWl.setEnabled(true);
            this.btnRenameWl.setEnabled(true);
        }
        catch (Exception e) {
            this.logger.error((Object)"error loading wanlist", (Throwable)e);
            JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
        }
    }

    public MkmWantListPanel() {
        this.initGUI();
    }

    protected void loadWantList(Wantslist selectedValue) {
        new Thread(() -> {
            try {
                this.serviceW.loadItems(selectedValue);
                this.itemsTableModel.init(selectedValue);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        }).start();
    }
}

