/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.services;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.api.mkm.modele.Article;
import org.api.mkm.modele.Basket;
import org.api.mkm.modele.ShoppingCart;
import org.api.mkm.tools.Tools;

public class CartServices {
    private XStream xstream = Tools.instNewXstream();

    public CartServices() {
        this.xstream.alias("response", Basket.class);
        this.xstream.addImplicitCollection(Basket.class, "shoppingCart", ShoppingCart.class);
        this.xstream.addImplicitCollection(ShoppingCart.class, "article", Article.class);
    }

    public boolean addArticle(Article a) throws IOException {
        ArrayList<Article> list = new ArrayList<Article>();
        list.add(a);
        return this.addArticles(list);
    }

    public boolean addArticles(List<Article> articles) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/shoppingcart";
        StringBuilder temp = new StringBuilder();
        temp.append("<?xml version='1.0' encoding='UTF-8'?>");
        temp.append("<request><action>add</action>");
        for (Article a : articles) {
            temp.append("<article>");
            temp.append("<idArticle>" + a.getIdArticle() + "</idArticle>");
            temp.append("<amount>" + a.getCount() + "</amount>");
            temp.append("</article>");
        }
        temp.append("</request>");
        Tools.getXMLResponse(link, "PUT", this.getClass(), temp.toString());
        return true;
    }

    public boolean empty() throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/shoppingcart";
        Tools.getXMLResponse(link, "DELETE", this.getClass());
        return true;
    }

    public boolean removeArticles(List<Article> articles) throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/shoppingcart";
        StringBuilder temp = new StringBuilder();
        temp.append("<?xml version='1.0' encoding='UTF-8'?>");
        temp.append("<request><action>remove</action>");
        for (Article a : articles) {
            temp.append("<article>");
            temp.append("<idArticle>" + a.getIdArticle() + "</idArticle>");
            temp.append("<amount>" + a.getCount() + "</amount>");
            temp.append("</article>");
        }
        temp.append("</request>");
        Tools.getXMLResponse(link, "PUT", this.getClass(), temp.toString());
        return true;
    }

    public Basket getBasket() throws IOException {
        String link = "https://api.cardmarket.com/ws/v2.0/shoppingcart";
        String xml = Tools.getXMLResponse(link, "GET", this.getClass());
        return (Basket)this.xstream.fromXML(xml);
    }
}

