/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLTools {
    private static XMLTools inst;
    private DocumentBuilder builder;
    private XPath path;

    private XMLTools() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        try {
            XPathFactory xpf = XPathFactory.newInstance();
            this.path = xpf.newXPath();
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LogManager.getLogger(this.getClass()).error((Object)e);
        }
    }

    public Document toDoc(String xml) throws SAXException, IOException {
        return this.builder.parse(new ByteArrayInputStream(xml.getBytes()));
    }

    public List<String> getElementAt(String xml, String xpath) throws SAXException, IOException, XPathExpressionException {
        Document d = this.toDoc(xml);
        NodeList list = (NodeList)this.path.compile(xpath).evaluate(d, XPathConstants.NODESET);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            ret.add(list.item(i).getTextContent());
        }
        return ret;
    }

    public static XMLTools inst() {
        if (inst == null) {
            inst = new XMLTools();
        }
        return inst;
    }
}

