/*
 * Decompiled with CFR 0.152.
 */
package org.mkm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.api.mkm.modele.Article;
import org.api.mkm.modele.User;
import org.api.mkm.services.ArticleService;
import org.api.mkm.services.UserService;
import org.mkm.gui.modeles.ArticlesTableModel;
import org.mkm.gui.modeles.UsersTableModel;

public class MkmUsersPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable tableUsers;
    private UsersTableModel usersModel;
    private ArticlesTableModel articlesModel;
    private transient Logger logger = LogManager.getLogger(this.getClass());
    private JTable tableArticles;

    private void initGUI() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelNorth = new JPanel();
        JTextField txtSearch = new JTextField(15);
        this.add((Component)panelNorth, "North");
        txtSearch.addActionListener(ae -> this.search(txtSearch.getText()));
        JLabel lblSearchUser = new JLabel("Search user : ");
        panelNorth.add(lblSearchUser);
        panelNorth.add(txtSearch);
        this.articlesModel = new ArticlesTableModel();
        this.usersModel = new UsersTableModel();
        this.tableUsers = new JTable(this.usersModel);
        this.tableArticles = new JTable(this.articlesModel);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        splitPane.setLeftComponent(new JScrollPane(this.tableUsers));
        splitPane.setRightComponent(new JScrollPane(this.tableArticles));
        this.add((Component)splitPane, "Center");
        this.tableUsers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EnumMap<Article.ARTICLES_ATT, String> map = new EnumMap<Article.ARTICLES_ATT, String>(Article.ARTICLES_ATT.class);
                User o = (User)MkmUsersPanel.this.tableUsers.getValueAt(MkmUsersPanel.this.tableUsers.getSelectedRow(), 0);
                map.put(Article.ARTICLES_ATT.start, "0");
                map.put(Article.ARTICLES_ATT.maxResults, "100");
                try {
                    List<Article> artts = new ArticleService().find(o, map);
                    MkmUsersPanel.this.articlesModel.init(artts);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
                }
            }
        });
    }

    protected void search(String text) {
        UserService services = new UserService();
        try {
            this.usersModel.init(services.findUsers(text));
        }
        catch (Exception e) {
            this.logger.error("error searching", (Throwable)e);
            JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
        }
    }

    public MkmUsersPanel() {
        this.initGUI();
    }
}

