/*
 * Decompiled with CFR 0.152.
 */
package org.mkm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.api.mkm.modele.MkmBoolean;
import org.api.mkm.modele.WantItem;

public class WantListItemEditorPanel
extends JDialog {
    private static final long serialVersionUID = 1L;
    private WantItem wantItem;
    private JTextField txtCount;
    JComboBox<MkmBoolean> cboAltered;
    JComboBox<MkmBoolean> cboFoil;
    JComboBox<MkmBoolean> cboPlaySet;
    JComboBox<MkmBoolean> cboMailAlert;
    JComboBox<String> cboMinCondition;
    JComboBox<MkmBoolean> cboSigned;
    private transient Logger logger = LogManager.getLogger(this.getClass());
    private MkmBoolean[] values = new MkmBoolean[]{new MkmBoolean(""), new MkmBoolean(true), new MkmBoolean(false)};
    private JTextField txtWishPrice;

    public WantListItemEditorPanel(WantItem wl) {
        try {
            this.wantItem = wl;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.initgui();
        this.pack();
        this.setTitle(wl.getProduct().toString());
        this.setModal(true);
    }

    private void initgui() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{94, 124, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JLabel lblCount = new JLabel("Count");
        GridBagConstraints gbclblCount = new GridBagConstraints();
        gbclblCount.anchor = 13;
        gbclblCount.insets = new Insets(0, 0, 5, 5);
        gbclblCount.gridx = 0;
        gbclblCount.gridy = 0;
        this.getContentPane().add((Component)lblCount, gbclblCount);
        this.txtCount = new JTextField("" + this.wantItem.getCount());
        GridBagConstraints gbctextField = new GridBagConstraints();
        gbctextField.insets = new Insets(0, 0, 5, 0);
        gbctextField.fill = 2;
        gbctextField.gridx = 1;
        gbctextField.gridy = 0;
        this.getContentPane().add((Component)this.txtCount, gbctextField);
        this.txtCount.setColumns(10);
        JLabel lblWantPrice = new JLabel("Want Price");
        GridBagConstraints gbclblWantPrice = new GridBagConstraints();
        gbclblWantPrice.anchor = 13;
        gbclblWantPrice.insets = new Insets(0, 0, 5, 5);
        gbclblWantPrice.gridx = 0;
        gbclblWantPrice.gridy = 1;
        this.getContentPane().add((Component)lblWantPrice, gbclblWantPrice);
        this.txtWishPrice = new JTextField("" + this.wantItem.getWishPrice());
        GridBagConstraints gbctxtWishPrice = new GridBagConstraints();
        gbctxtWishPrice.insets = new Insets(0, 0, 5, 0);
        gbctxtWishPrice.fill = 2;
        gbctxtWishPrice.gridx = 1;
        gbctxtWishPrice.gridy = 1;
        this.getContentPane().add((Component)this.txtWishPrice, gbctxtWishPrice);
        this.txtWishPrice.setColumns(10);
        JLabel lblAltered = new JLabel("Altered");
        GridBagConstraints gbclblAltered = new GridBagConstraints();
        gbclblAltered.anchor = 13;
        gbclblAltered.insets = new Insets(0, 0, 5, 5);
        gbclblAltered.gridx = 0;
        gbclblAltered.gridy = 2;
        this.getContentPane().add((Component)lblAltered, gbclblAltered);
        this.cboAltered = new JComboBox<MkmBoolean>(new DefaultComboBoxModel<MkmBoolean>(this.values));
        this.cboAltered.setSelectedItem(new MkmBoolean(this.wantItem.isAltered()));
        GridBagConstraints gbccboAltered = new GridBagConstraints();
        gbccboAltered.insets = new Insets(0, 0, 5, 0);
        gbccboAltered.fill = 2;
        gbccboAltered.gridx = 1;
        gbccboAltered.gridy = 2;
        this.getContentPane().add(this.cboAltered, gbccboAltered);
        JLabel lblFoil = new JLabel("Foil ");
        GridBagConstraints gbclblFoil = new GridBagConstraints();
        gbclblFoil.anchor = 13;
        gbclblFoil.insets = new Insets(0, 0, 5, 5);
        gbclblFoil.gridx = 0;
        gbclblFoil.gridy = 3;
        this.getContentPane().add((Component)lblFoil, gbclblFoil);
        this.cboFoil = new JComboBox<MkmBoolean>(new DefaultComboBoxModel<MkmBoolean>(this.values));
        this.cboFoil.setSelectedItem(new MkmBoolean(this.wantItem.isFoil()));
        GridBagConstraints gbccboFoil = new GridBagConstraints();
        gbccboFoil.insets = new Insets(0, 0, 5, 0);
        gbccboFoil.fill = 2;
        gbccboFoil.gridx = 1;
        gbccboFoil.gridy = 3;
        this.getContentPane().add(this.cboFoil, gbccboFoil);
        JLabel lblPlayset = new JLabel("Playset");
        GridBagConstraints gbclblPlayset = new GridBagConstraints();
        gbclblPlayset.anchor = 13;
        gbclblPlayset.insets = new Insets(0, 0, 5, 5);
        gbclblPlayset.gridx = 0;
        gbclblPlayset.gridy = 4;
        this.getContentPane().add((Component)lblPlayset, gbclblPlayset);
        this.cboPlaySet = new JComboBox<MkmBoolean>(new DefaultComboBoxModel<MkmBoolean>(this.values));
        this.cboPlaySet.setSelectedItem(new MkmBoolean(this.wantItem.isPlayset()));
        GridBagConstraints gbccboPlaySet = new GridBagConstraints();
        gbccboPlaySet.insets = new Insets(0, 0, 5, 0);
        gbccboPlaySet.fill = 2;
        gbccboPlaySet.gridx = 1;
        gbccboPlaySet.gridy = 4;
        this.getContentPane().add(this.cboPlaySet, gbccboPlaySet);
        JLabel lblMailAlert = new JLabel("Mail Alert ");
        GridBagConstraints gbclblMailAlert = new GridBagConstraints();
        gbclblMailAlert.anchor = 13;
        gbclblMailAlert.insets = new Insets(0, 0, 5, 5);
        gbclblMailAlert.gridx = 0;
        gbclblMailAlert.gridy = 5;
        this.getContentPane().add((Component)lblMailAlert, gbclblMailAlert);
        this.cboMailAlert = new JComboBox<MkmBoolean>(new DefaultComboBoxModel<MkmBoolean>(this.values));
        this.cboMailAlert.setSelectedItem(new MkmBoolean(this.wantItem.isMailAlert()));
        GridBagConstraints gbccboMailAlert = new GridBagConstraints();
        gbccboMailAlert.insets = new Insets(0, 0, 5, 0);
        gbccboMailAlert.fill = 2;
        gbccboMailAlert.gridx = 1;
        gbccboMailAlert.gridy = 5;
        this.getContentPane().add(this.cboMailAlert, gbccboMailAlert);
        JLabel lblMinCondition = new JLabel("Min Condition");
        GridBagConstraints gbclblMinCondition = new GridBagConstraints();
        gbclblMinCondition.anchor = 13;
        gbclblMinCondition.insets = new Insets(0, 0, 5, 5);
        gbclblMinCondition.gridx = 0;
        gbclblMinCondition.gridy = 6;
        this.getContentPane().add((Component)lblMinCondition, gbclblMinCondition);
        this.cboMinCondition = new JComboBox<String>(new DefaultComboBoxModel<String>(WantItem.CONDITIONS));
        this.cboMinCondition.setSelectedItem(this.wantItem.getMinCondition());
        GridBagConstraints gbccboMinCondition = new GridBagConstraints();
        gbccboMinCondition.insets = new Insets(0, 0, 5, 0);
        gbccboMinCondition.fill = 2;
        gbccboMinCondition.gridx = 1;
        gbccboMinCondition.gridy = 6;
        this.getContentPane().add(this.cboMinCondition, gbccboMinCondition);
        JLabel lblSigned = new JLabel("Signed");
        GridBagConstraints gbclblSigned = new GridBagConstraints();
        gbclblSigned.anchor = 13;
        gbclblSigned.insets = new Insets(0, 0, 5, 5);
        gbclblSigned.gridx = 0;
        gbclblSigned.gridy = 7;
        this.getContentPane().add((Component)lblSigned, gbclblSigned);
        this.cboSigned = new JComboBox<MkmBoolean>(new DefaultComboBoxModel<MkmBoolean>(this.values));
        this.cboSigned.setSelectedItem(new MkmBoolean(this.wantItem.isSigned()));
        GridBagConstraints gbccboSigned = new GridBagConstraints();
        gbccboSigned.insets = new Insets(0, 0, 5, 0);
        gbccboSigned.fill = 2;
        gbccboSigned.gridx = 1;
        gbccboSigned.gridy = 7;
        this.getContentPane().add(this.cboSigned, gbccboSigned);
        JPanel panel = new JPanel();
        GridBagConstraints gbcpanel = new GridBagConstraints();
        gbcpanel.gridwidth = 2;
        gbcpanel.fill = 1;
        gbcpanel.gridx = 0;
        gbcpanel.gridy = 8;
        this.getContentPane().add((Component)panel, gbcpanel);
        JButton btnOk = new JButton("OK");
        btnOk.addActionListener(paramActionEvent -> {
            this.save();
            this.dispose();
        });
        panel.add(btnOk);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(paramActionEvent -> {
            this.wantItem = null;
            this.dispose();
        });
        panel.add(btnCancel);
    }

    public void save() {
        try {
            this.wantItem.setCount(Integer.parseInt(this.txtCount.getText()));
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        try {
            this.wantItem.setWishPrice(Double.parseDouble(this.txtWishPrice.getText()));
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.wantItem.getIdLanguage().remove(0);
        this.wantItem.getIdLanguage().add(1);
        this.wantItem.setAltered((MkmBoolean)this.cboAltered.getSelectedItem());
        this.wantItem.setFoil((MkmBoolean)this.cboFoil.getSelectedItem());
        this.wantItem.setMailAlert((MkmBoolean)this.cboMailAlert.getSelectedItem());
        this.wantItem.setPlayset((MkmBoolean)this.cboPlaySet.getSelectedItem());
        this.wantItem.setSigned((MkmBoolean)this.cboSigned.getSelectedItem());
        this.wantItem.setMinCondition(String.valueOf(this.cboMinCondition.getSelectedItem()));
    }

    public WantItem getItem() {
        return this.wantItem;
    }
}

