/*
 * Decompiled with CFR 0.152.
 */
package org.mkm.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.api.mkm.modele.Product;

public class ProductListPanel
extends JPanel {
    private transient Logger logger = LogManager.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    Product p;

    public ProductListPanel(Product p) {
        this.p = p;
        this.setBackground(Color.WHITE);
        this.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{77, 230, 0};
        gridBagLayout.rowHeights = new int[]{14, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblPics = new JLabel();
        try {
            BufferedImage img = ImageIO.read(new URL("https:" + p.getImage()));
            lblPics.setIcon(new ImageIcon(img.getScaledInstance(85, 118, 4)));
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        GridBagConstraints gbclblPics = new GridBagConstraints();
        gbclblPics.gridheight = 3;
        gbclblPics.insets = new Insets(0, 0, 5, 5);
        gbclblPics.gridx = 0;
        gbclblPics.gridy = 1;
        this.add((Component)lblPics, gbclblPics);
        JLabel lblName = new JLabel(p.getEnName());
        lblName.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbclblName = new GridBagConstraints();
        gbclblName.gridwidth = 2;
        gbclblName.insets = new Insets(0, 0, 5, 0);
        gbclblName.anchor = 18;
        gbclblName.gridx = 0;
        gbclblName.gridy = 0;
        this.add((Component)lblName, gbclblName);
        JLabel lblEdition = new JLabel(p.getExpansionName());
        GridBagConstraints gbclblEdition = new GridBagConstraints();
        gbclblEdition.insets = new Insets(0, 0, 5, 0);
        gbclblEdition.anchor = 17;
        gbclblEdition.gridx = 1;
        gbclblEdition.gridy = 1;
        this.add((Component)lblEdition, gbclblEdition);
        JLabel lblIdProduct = new JLabel("ID " + p.getIdProduct());
        GridBagConstraints gbclblidProduct = new GridBagConstraints();
        gbclblidProduct.anchor = 17;
        gbclblidProduct.insets = new Insets(0, 0, 5, 0);
        gbclblidProduct.gridx = 1;
        gbclblidProduct.gridy = 2;
        this.add((Component)lblIdProduct, gbclblidProduct);
        JLabel lblType = new JLabel(p.getCategoryName());
        GridBagConstraints gbclblType = new GridBagConstraints();
        gbclblType.anchor = 17;
        gbclblType.gridx = 1;
        gbclblType.gridy = 3;
        this.add((Component)lblType, gbclblType);
    }
}

