/*
 * Decompiled with CFR 0.152.
 */
package org.api.mkm.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.api.mkm.exceptions.MkmException;
import org.api.mkm.services.AuthenticationServices;

public class MkmAPIConfig {
    private static MkmAPIConfig instance;
    private int maxCall = 0;
    private int countCall;
    static final Logger logger;
    AuthenticationServices auth;

    public void init(String accessSecret, String accessToken, String appSecret, String appToken) throws MkmException {
        this.auth = new AuthenticationServices(accessSecret, accessToken, appSecret, appToken);
    }

    public void init(Properties magicCardMaketPropFile) throws MkmException {
        this.init(magicCardMaketPropFile.getProperty("APP_ACCESS_TOKEN_SECRET"), magicCardMaketPropFile.getProperty("APP_ACCESS_TOKEN"), magicCardMaketPropFile.getProperty("APP_SECRET"), magicCardMaketPropFile.getProperty("APP_TOKEN"));
    }

    public void init(File magicCardMaketPropFile) throws IOException {
        Properties p = new Properties();
        try (FileInputStream fis = new FileInputStream(magicCardMaketPropFile);){
            p.load(fis);
            this.init(p);
        }
    }

    public static MkmAPIConfig getInstance() {
        if (instance == null) {
            instance = new MkmAPIConfig();
        }
        return instance;
    }

    public AuthenticationServices getAuthenticator() {
        return this.auth;
    }

    public void updateCount(HttpURLConnection connection) {
        String limit = connection.getHeaderField("X-Request-Limit-Max");
        String count = connection.getHeaderField("X-Request-Limit-Count");
        if (this.maxCall == 0 && limit != null) {
            this.maxCall = Integer.parseInt(limit);
        }
        if (count != null) {
            this.countCall = Integer.parseInt(count);
        }
        logger.debug("call : " + this.countCall + "/" + this.maxCall);
    }

    public int getCountCall() {
        return this.countCall;
    }

    public int getMaxCall() {
        return this.maxCall;
    }

    static {
        logger = LogManager.getLogger((String)MkmAPIConfig.class.getName());
    }
}

