/*
 * Decompiled with CFR 0.152.
 */
package org.mkm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EnumMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.api.mkm.modele.Article;
import org.api.mkm.modele.Product;
import org.api.mkm.services.ArticleService;
import org.api.mkm.services.ProductServices;
import org.mkm.gui.modeles.ArticlesTableModel;
import org.mkm.gui.renderer.ProductListRenderer;

public class MkmMetaSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LogManager.getLogger(this.getClass());
    private JList<Product> listResults;
    private DefaultListModel<Product> productsModel;
    private ArticlesTableModel articlesModel;
    private JPanel panelEast;
    private JLabel lblPics;
    private JComboBox comboBox;

    private void initGUI() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelNorth = new JPanel();
        this.add((Component)panelNorth, "North");
        JTextField txtSearch = new JTextField();
        txtSearch.addActionListener(ae -> this.search(txtSearch.getText()));
        panelNorth.add(new JLabel("Search meta product : "));
        this.comboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(ProductServices.getLangs()));
        panelNorth.add(this.comboBox);
        panelNorth.add(txtSearch);
        txtSearch.setColumns(15);
        panelNorth.add(new JLabel("or by id : "));
        JTextField txtIdMeta = new JTextField();
        txtIdMeta.addActionListener(ae -> this.searchID(Integer.parseInt(txtIdMeta.getText())));
        panelNorth.add(txtIdMeta);
        txtIdMeta.setColumns(10);
        JPanel panelSouth = new JPanel();
        this.add((Component)panelSouth, "South");
        JScrollPane panelWest = new JScrollPane();
        this.add((Component)panelWest, "West");
        this.productsModel = new DefaultListModel();
        this.listResults = new JList<Product>(this.productsModel);
        this.listResults.setCellRenderer(new ProductListRenderer());
        this.listResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                MkmMetaSearchPanel.this.loadArticle(MkmMetaSearchPanel.this.listResults.getSelectedValue());
            }
        });
        panelWest.setViewportView(this.listResults);
        JScrollPane panelCenter = new JScrollPane();
        this.add((Component)panelCenter, "Center");
        this.articlesModel = new ArticlesTableModel();
        JTable tableArticles = new JTable(this.articlesModel);
        panelCenter.setViewportView(tableArticles);
    }

    protected void searchID(int id) {
        ProductServices services = new ProductServices();
        try {
            this.productsModel.removeAllElements();
            Product p = services.getMetaProductById(id);
            this.productsModel.addElement(p);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
        }
    }

    protected void search(String text) {
        ProductServices services = new ProductServices();
        EnumMap<Product.PRODUCT_ATTS, String> map = new EnumMap<Product.PRODUCT_ATTS, String>(Product.PRODUCT_ATTS.class);
        map.put(Product.PRODUCT_ATTS.idLanguage, "" + (this.comboBox.getSelectedIndex() + 1));
        this.productsModel.removeAllElements();
        try {
            for (Product p : services.findMetaProduct(text, map)) {
                this.productsModel.addElement(p);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
        }
    }

    public MkmMetaSearchPanel() {
        this.initGUI();
        try {
            this.panelEast = new JPanel();
            this.add((Component)this.panelEast, "East");
            this.lblPics = new JLabel("");
            this.panelEast.add(this.lblPics);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    protected void loadArticle(Product selectedValue) {
        ArticleService service = new ArticleService();
        EnumMap<Article.ARTICLES_ATT, String> atts = new EnumMap<Article.ARTICLES_ATT, String>(Article.ARTICLES_ATT.class);
        atts.put(Article.ARTICLES_ATT.start, "0");
        atts.put(Article.ARTICLES_ATT.maxResults, "100");
        try {
            this.articlesModel.init(service.find(selectedValue, atts));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
        }
    }
}

