/*
 * Decompiled with CFR 0.152.
 */
package com.github.nill14.utils.java8.stream;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    private StreamUtils() {
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1040), false);
    }

    public static <T> Stream<T> stream(final Supplier<Boolean> hasNext, final Supplier<T> next) {
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return (Boolean)hasNext.get();
            }

            @Override
            public T next() {
                return next.get();
            }
        };
        return StreamUtils.stream(iterator);
    }
}

