/*
 * Decompiled with CFR 0.152.
 */
package com.github.nill14.utils.java8.stream;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;

public class ExecutorUtils {
    private ExecutorUtils() {
    }

    public static <E, R> ImmutableList<R> parallelExecution(ExecutorService executor, Collection<E> elements, Function<E, R> mappingFunction) throws InterruptedException, ExecutionException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(elements.size());
        for (E element : elements) {
            futures.add(executor.submit(() -> mappingFunction.apply(element)));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Future future : futures) {
            builder.add(future.get());
        }
        return builder.build();
    }
}

