/*
 * Decompiled with CFR 0.152.
 */
package com.github.oohira.intercom;

import com.github.oohira.intercom.IntercomException;
import com.github.oohira.intercom.UserIterator;
import com.github.oohira.intercom.model.Company;
import com.github.oohira.intercom.model.ErrorResponse;
import com.github.oohira.intercom.model.Impression;
import com.github.oohira.intercom.model.Note;
import com.github.oohira.intercom.model.Tag;
import com.github.oohira.intercom.model.User;
import com.github.oohira.intercom.model.UserCollection;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;

public class Intercom {
    private static final String API_ENDPOINT_URL = "https://api.intercom.io/v1";
    private static final String USERS_API_URL = "https://api.intercom.io/v1/users";
    private static final String NOTES_API_URL = "https://api.intercom.io/v1/users/notes";
    private static final String IMPRESSIONS_API_URL = "https://api.intercom.io/v1/users/impressions";
    private static final String TAGGING_API_URL = "https://api.intercom.io/v1/tags";
    private static final String COMPANIES_API_URL = "https://api.intercom.io/v1/companies";
    private static final String DEBUG_KEY = "intercom.debug";
    private static final Logger LOGGER = Logger.getLogger(Intercom.class.getName());
    private final Gson gson;
    private String appId;
    private String apiKey;
    private Integer perPage;

    public Intercom() {
        this(null, null);
    }

    public Intercom(String appId, String apiKey) {
        this.appId = appId;
        this.apiKey = apiKey;
        this.gson = this.initializeGson();
    }

    private Gson initializeGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new Date(json.getAsJsonPrimitive().getAsLong() * 1000L);
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive((Number)(src.getTime() / 1000L));
            }
        });
        builder.registerTypeAdapter(Company.class, (Object)new JsonSerializer<Company>(){

            public JsonElement serialize(Company company, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject result = new JsonObject();
                result.add("id", context.serialize((Object)company.getId()));
                result.add("name", context.serialize((Object)company.getName()));
                result.add("created_at", context.serialize((Object)company.getCreatedAt()));
                result.add("plan", context.serialize((Object)company.getPlan()));
                result.add("monthly_spend", context.serialize((Object)company.getMonthlySpend()));
                Map<String, Object> customData = company.getCustomData();
                if (customData != null) {
                    for (String key : customData.keySet()) {
                        result.add(key, context.serialize(customData.get(key)));
                    }
                }
                return result;
            }
        });
        return builder.create();
    }

    private void log(Level level, String message) {
        if (Boolean.getBoolean(DEBUG_KEY)) {
            LOGGER.log(level, message);
        }
    }

    public <T> String serialize(T object) {
        return this.gson.toJson(object);
    }

    public <T> T deserialize(String json, Class<T> clazz) throws IntercomException {
        try {
            return (T)this.gson.fromJson(json, clazz);
        }
        catch (JsonParseException e) {
            throw new IntercomException(e);
        }
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    void setUserCountPerPage(Integer perPage) {
        this.perPage = perPage;
    }

    public UserIterator getUsers() {
        return new UserIterator(this, null);
    }

    public UserIterator getUsersByTagName(String tagName) {
        return new UserIterator(this, tagName);
    }

    UserCollection getUsers(int page, String tagName) throws IntercomException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", String.valueOf(page));
        if (this.perPage != null) {
            params.put("per_page", this.perPage.toString());
        }
        if (tagName != null) {
            params.put("tag_name", tagName);
        }
        String response = this.httpGet(USERS_API_URL, params);
        return this.deserialize(response, UserCollection.class);
    }

    public int getUserCount() throws IntercomException {
        UserCollection collection = this.getUsers(1, null);
        if (collection == null) {
            return 0;
        }
        return collection.getTotalCount();
    }

    public User getUserById(String userId) throws IntercomException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user_id", userId);
        String response = this.httpGet(USERS_API_URL, params);
        return this.deserialize(response, User.class);
    }

    public User getUserByEmail(String email) throws IntercomException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        String response = this.httpGet(USERS_API_URL, params);
        return this.deserialize(response, User.class);
    }

    public User createUser(User user) throws IntercomException {
        String json = this.serialize(user);
        String response = this.httpPost(USERS_API_URL, json);
        return this.deserialize(response, User.class);
    }

    public User updateUser(User user) throws IntercomException {
        String json = this.serialize(user);
        String response = this.httpPut(USERS_API_URL, json);
        return this.deserialize(response, User.class);
    }

    public User deleteUserById(String userId) throws IntercomException {
        User user = new User();
        user.setUserId(userId);
        String json = this.serialize(user);
        String response = this.httpDelete(USERS_API_URL, json);
        return this.deserialize(response, User.class);
    }

    public User deleteUserByEmail(String email) throws IntercomException {
        User user = new User();
        user.setEmail(email);
        String json = this.serialize(user);
        String response = this.httpDelete(USERS_API_URL, json);
        return this.deserialize(response, User.class);
    }

    void clearUsers() throws IntercomException {
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> emails = new ArrayList<String>();
        for (User user : this.getUsers()) {
            String userId = user.getUserId();
            if (userId != null) {
                userIds.add(userId);
                continue;
            }
            emails.add(user.getEmail());
        }
        for (String userId : userIds) {
            this.deleteUserById(userId);
        }
        for (String email : emails) {
            this.deleteUserByEmail(email);
        }
    }

    public Company getCompanyById(String companyId) throws IntercomException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", companyId);
        String response = this.httpGet(COMPANIES_API_URL, params);
        return this.deserialize(response, Company.class);
    }

    public Tag getTag(String name) throws IntercomException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        String response = this.httpGet(TAGGING_API_URL, params);
        return this.deserialize(response, Tag.class);
    }

    public Tag createTag(Tag tag) throws IntercomException {
        String json = this.serialize(tag);
        String response = this.httpPost(TAGGING_API_URL, json);
        return this.deserialize(response, Tag.class);
    }

    public Tag updateTag(Tag tag) throws IntercomException {
        String json = this.serialize(tag);
        String response = this.httpPut(TAGGING_API_URL, json);
        return this.deserialize(response, Tag.class);
    }

    public Note createNote(Note note) throws IntercomException {
        String json = this.serialize(note);
        String response = this.httpPost(NOTES_API_URL, json);
        return this.deserialize(response, Note.class);
    }

    public Impression createImpression(Impression impression) throws IntercomException {
        String json = this.serialize(impression);
        String response = this.httpPost(IMPRESSIONS_API_URL, json);
        return this.deserialize(response, Impression.class);
    }

    private String httpGet(String url, Map<String, String> params) throws IntercomException {
        try {
            StringBuilder buf = new StringBuilder();
            for (String key : params.keySet()) {
                buf.append(buf.length() == 0 ? "?" : "&");
                buf.append(URLEncoder.encode(key, "UTF-8"));
                buf.append("=");
                buf.append(URLEncoder.encode(params.get(key), "UTF-8"));
            }
            return this.send(url + buf, "GET", null);
        }
        catch (UnsupportedEncodingException e) {
            throw new IntercomException(e);
        }
    }

    private String httpPost(String url, String body) throws IntercomException {
        return this.send(url, "POST", body);
    }

    private String httpPut(String url, String body) throws IntercomException {
        return this.send(url, "PUT", body);
    }

    private String httpDelete(String url, String body) throws IntercomException {
        return this.send(url, "DELETE", body);
    }

    private String encodeBasicAuthenticationString() {
        if (this.appId != null && this.apiKey != null) {
            String str = this.appId + ":" + this.apiKey;
            return "Basic " + Base64.encodeBase64String((byte[])str.getBytes());
        }
        return null;
    }

    private String send(String url, String method, String body) throws IntercomException {
        HttpURLConnection http = null;
        try {
            int statusCode;
            this.log(Level.INFO, String.format("%s %s %s", method, url, body));
            http = (HttpURLConnection)new URL(url).openConnection();
            http.setRequestMethod(method);
            String authorizationHeader = this.encodeBasicAuthenticationString();
            if (authorizationHeader != null) {
                http.setRequestProperty("Authorization", authorizationHeader);
            }
            if (method.equals("POST") || method.equals("PUT") || method.equals("DELETE")) {
                http.setDoOutput(true);
                http.setRequestProperty("Content-Type", "application/json");
                http.setRequestProperty("Content-Length", String.valueOf(body));
            }
            http.connect();
            if (method.equals("POST") || method.equals("PUT") || method.equals("DELETE")) {
                OutputStreamWriter writer = new OutputStreamWriter(http.getOutputStream());
                writer.write(body);
                writer.close();
            }
            if ((statusCode = http.getResponseCode()) == 200 || statusCode == 201) {
                String response = this.getResponse(http.getInputStream());
                this.log(Level.INFO, response);
                String string = response;
                return string;
            }
            try {
                String response = this.getResponse(http.getErrorStream());
                this.log(Level.WARNING, response);
                ErrorResponse error = this.deserialize(response, ErrorResponse.class);
                error.setStatusCode(statusCode);
                throw new IntercomException(error);
            }
            catch (IOException e) {
                throw new IntercomException(e);
            }
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
        }
    }

    private String getResponse(InputStream stream) throws IntercomException {
        if (stream == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
        catch (IOException e) {
            throw new IntercomException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

