/*
 * Decompiled with CFR 0.152.
 */
package com.alon.querydecoder;

import com.alon.querydecoder.ExpressionParser;
import com.alon.querydecoder.LogicalOperator;
import com.alon.querydecoder.Match;
import com.alon.querydecoder.MatchType;
import com.alon.querydecoder.SingleExpression;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SingleExpressionParser {
    private static final Pattern FIELD_PATTERN = Pattern.compile("((\\w.*(?=:))(?<!\\]))|(\\w.*(?=\\[))");
    private static final Pattern MATCH_PATTERN = Pattern.compile("(?<=\\[).+(?=\\])");
    private static final Pattern VALUE_PATTERN = Pattern.compile("(?<=:).*");
    private SingleExpression building;

    private SingleExpressionParser(String expression) {
        ExpressionParser.validateStartOfExpression(expression);
        this.building = new SingleExpression();
        expression = this.normalize(expression);
        this.building.setLogicalOperator(this.determineLogicalOperator(expression));
        String currentExpression = this.isolateFirstExpression(expression);
        this.building.setField(this.determineField(currentExpression));
        this.building.setMatch(this.determineMatch(currentExpression));
        this.building.setValue(this.determineValue(currentExpression));
        if (!expression.equals(currentExpression)) {
            expression = this.removeFirstExpression(expression);
            this.building.setNext(ExpressionParser.parse(expression));
        }
    }

    public static SingleExpression parse(String expression) {
        SingleExpressionParser builder = new SingleExpressionParser(expression);
        return builder.building;
    }

    private String normalize(String expression) {
        return expression.replace(" and ", " AND ").replace(" or ", " OR ").trim();
    }

    private LogicalOperator determineLogicalOperator(String expression) {
        int and = expression.indexOf(" AND ");
        int or = expression.indexOf(" OR ");
        and = and < 0 ? expression.length() : and;
        int n = or = or < 0 ? expression.length() : or;
        if (and < or) {
            return LogicalOperator.AND;
        }
        if (or < and) {
            return LogicalOperator.OR;
        }
        return null;
    }

    private String isolateFirstExpression(String expression) {
        return expression.substring(0, this.getLogicalOperatorIndex(expression)).trim();
    }

    private int getLogicalOperatorIndex(String expression) {
        if (this.building.getLogicalOperator() == null) {
            return expression.length();
        }
        return expression.indexOf(this.building.getLogicalOperator().name());
    }

    private String removeFirstExpression(String expression) {
        int index;
        if (this.building.getLogicalOperator() != null) {
            index = expression.indexOf(this.building.getLogicalOperator().name());
            index = this.building.getLogicalOperator().equals((Object)LogicalOperator.AND) ? (index += 4) : (index += 3);
        } else {
            index = expression.length();
        }
        return expression.substring(index).trim();
    }

    private String determineField(String expression) {
        Matcher m = FIELD_PATTERN.matcher(expression);
        if (m.find()) {
            return m.group();
        }
        throw new IllegalArgumentException(String.format("Field not found in <%s>.", expression));
    }

    private Match determineMatch(String expression) {
        Matcher matcher = MATCH_PATTERN.matcher(expression);
        String matchStr = matcher.find() ? matcher.group().toUpperCase() : "EQ";
        boolean negated = matchStr.startsWith("N");
        if (negated) {
            matchStr = matchStr.substring(1);
        }
        try {
            MatchType matchType = MatchType.valueOf(matchStr);
            return new Match(matchType, negated);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unknown match type: %s. The valid match types are: %s.", matchStr, this.getValidMatchTypes()));
        }
    }

    private String getValidMatchTypes() {
        List matchTypes = Stream.of(MatchType.values()).map(item -> item.name()).collect(Collectors.toList());
        return matchTypes.stream().map(matchType -> String.format("N%s", matchType)).flatMap(value -> matchTypes.stream()).collect(Collectors.joining(", "));
    }

    private String determineValue(String expression) {
        Matcher matcher = VALUE_PATTERN.matcher(expression);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new IllegalArgumentException(String.format("Value not found in <%s>.", expression));
    }
}

