/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.impl;

import com.pengrad.telegrambot.Callback;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.UpdatesListener;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.request.GetUpdates;
import com.pengrad.telegrambot.response.GetUpdatesResponse;
import java.io.IOException;
import java.util.List;

public class UpdatesHandler {
    private TelegramBot bot;
    private UpdatesListener listener;
    private final long sleepTimeout;

    public UpdatesHandler(long sleepTimeout) {
        this.sleepTimeout = sleepTimeout;
    }

    public void start(TelegramBot bot, UpdatesListener listener, GetUpdates request) {
        this.bot = bot;
        this.listener = listener;
        this.getUpdates(request);
    }

    public void stop() {
        this.bot = null;
        this.listener = null;
    }

    private void getUpdates(GetUpdates request) {
        if (this.bot == null || this.listener == null) {
            return;
        }
        this.bot.execute(request, new Callback<GetUpdates, GetUpdatesResponse>(){

            @Override
            public void onResponse(GetUpdates request, GetUpdatesResponse response) {
                if (UpdatesHandler.this.listener == null) {
                    return;
                }
                if (!response.isOk() || response.updates() == null || response.updates().size() <= 0) {
                    UpdatesHandler.this.sleep();
                    UpdatesHandler.this.getUpdates(request);
                    return;
                }
                List<Update> updates = response.updates();
                int lastConfirmedUpdate = UpdatesHandler.this.listener.process(updates);
                if (lastConfirmedUpdate != -2) {
                    int offset = lastConfirmedUpdate == -1 ? UpdatesHandler.this.lastUpdateId(updates) + 1 : lastConfirmedUpdate + 1;
                    request = request.offset(offset);
                }
                UpdatesHandler.this.getUpdates(request);
            }

            @Override
            public void onFailure(GetUpdates request, IOException e) {
                UpdatesHandler.this.sleep();
                UpdatesHandler.this.getUpdates(request);
            }
        });
    }

    private int lastUpdateId(List<Update> updates) {
        return updates.get(updates.size() - 1).updateId();
    }

    private void sleep() {
        if (this.sleepTimeout <= 0L) {
            return;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

