/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.request;

import com.pengrad.telegrambot.response.BaseResponse;
import com.pengrad.telegrambot.utility.BotUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseRequest<T extends BaseRequest<T, R>, R extends BaseResponse> {
    protected final T thisAsT = this;
    private final Class<? extends R> responseClass;
    private final Map<String, Object> parameters;

    public BaseRequest(Class<? extends R> responseClass) {
        this.responseClass = responseClass;
        this.parameters = new LinkedHashMap<String, Object>();
    }

    protected T add(String name, Object val) {
        this.parameters.put(name, val);
        return this.thisAsT;
    }

    protected T addAll(Map<String, Object> values) {
        this.parameters.putAll(values);
        return this.thisAsT;
    }

    public String getMethod() {
        String className = this.getClass().getSimpleName();
        return Character.toLowerCase(className.charAt(0)) + className.substring(1);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Class<? extends R> getResponseType() {
        return this.responseClass;
    }

    public boolean isMultipart() {
        return false;
    }

    public String getFileName() {
        return "file.txt";
    }

    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    public int getTimeoutSeconds() {
        return 0;
    }

    public String toWebhookResponse() {
        LinkedHashMap<String, Object> fullMap = new LinkedHashMap<String, Object>(this.parameters);
        fullMap.put("method", this.getMethod());
        return BotUtils.toJson(fullMap);
    }
}

