/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.model.request;

import com.pengrad.telegrambot.AttachName;
import com.pengrad.telegrambot.model.MessageEntity;
import com.pengrad.telegrambot.model.request.InputFile;
import com.pengrad.telegrambot.model.request.ParseMode;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class InputMedia<T extends InputMedia<T>>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final T thisAsT = this;
    private final String type;
    private final String media;
    private String thumbnail;
    private String caption;
    private String parse_mode;
    private MessageEntity[] caption_entities;
    private transient Map<String, Object> attachments = new HashMap<String, Object>();
    private transient InputFile inputFile;
    private transient String inputFileAttachId;
    private transient String fileName;
    private transient String contentType;

    InputMedia(String type, Object media) {
        this.type = type;
        if (media instanceof String) {
            this.media = (String)media;
        } else {
            String attachName = AttachName.next();
            this.media = "attach://" + attachName;
            this.inputFileAttachId = attachName;
            if (media instanceof File) {
                this.fileName = ((File)media).getName();
                this.inputFile = new InputFile((File)media, this.getFileName(), this.getContentType());
            } else if (media instanceof byte[]) {
                this.inputFile = new InputFile((byte[])media, this.getFileName(), this.getContentType());
            }
        }
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    public String getInputFileId() {
        return this.inputFileAttachId;
    }

    @Deprecated
    public T thumb(File thumb) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, thumb);
        this.thumbnail = "attach://" + attachName;
        return this.thisAsT;
    }

    @Deprecated
    public T thumb(byte[] thumb) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, thumb);
        this.thumbnail = "attach://" + attachName;
        return this.thisAsT;
    }

    public T thumbnail(File thumbnail) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, thumbnail);
        this.thumbnail = "attach://" + attachName;
        return this.thisAsT;
    }

    public T thumbnail(byte[] thumbnail) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, thumbnail);
        this.thumbnail = "attach://" + attachName;
        return this.thisAsT;
    }

    public T caption(String caption) {
        this.caption = caption;
        return this.thisAsT;
    }

    public T parseMode(ParseMode parseMode) {
        this.parse_mode = parseMode.name();
        return this.thisAsT;
    }

    public T captionEntities(MessageEntity ... entities) {
        this.caption_entities = entities;
        return this.thisAsT;
    }

    public T fileName(String fileName) {
        if (this.inputFile != null) {
            this.inputFile.setFileName(fileName);
        }
        this.fileName = fileName;
        return this.thisAsT;
    }

    public T contentType(String contentType) {
        if (this.inputFile != null) {
            this.inputFile.setContentType(contentType);
        }
        this.contentType = contentType;
        return this.thisAsT;
    }

    public String getFileName() {
        return this.fileName != null && !this.fileName.isEmpty() ? this.fileName : this.getDefaultFileName();
    }

    public String getContentType() {
        return this.contentType != null && !this.contentType.isEmpty() ? this.contentType : this.getDefaultContentType();
    }

    protected abstract String getDefaultFileName();

    protected abstract String getDefaultContentType();
}

