/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.model.request;

import com.pengrad.telegrambot.AttachName;
import com.pengrad.telegrambot.model.request.InputPaidMedia;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class InputPaidMediaVideo
extends InputPaidMedia
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer width;
    private Integer height;
    private Integer duration;
    private Boolean supports_streaming;
    private String thumbnail;
    private transient Map<String, Object> attachments = new HashMap<String, Object>();

    public InputPaidMediaVideo(String media) {
        super("video", media);
    }

    public InputPaidMediaVideo(File media) {
        super("video", media);
    }

    public InputPaidMediaVideo(byte[] media) {
        super("video", media);
    }

    public InputPaidMediaVideo width(Integer width) {
        this.width = width;
        return this;
    }

    public InputPaidMediaVideo height(Integer height) {
        this.height = height;
        return this;
    }

    public InputPaidMediaVideo duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public InputPaidMediaVideo supportsStreaming(boolean supportsStreaming) {
        this.supports_streaming = supportsStreaming;
        return this;
    }

    public InputPaidMediaVideo thumbnail(File thumbnail) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, thumbnail);
        this.thumbnail = "attach://" + attachName;
        return this;
    }

    public InputPaidMediaVideo thumbnail(byte[] thumbnail) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, thumbnail);
        this.thumbnail = "attach://" + attachName;
        return this;
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getDefaultFileName() {
        return "file.mp4";
    }

    @Override
    public String getDefaultContentType() {
        return "video/mp4";
    }
}

