/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.request;

import com.pengrad.telegrambot.model.request.InputMedia;
import com.pengrad.telegrambot.model.request.ReplyParameters;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.response.MessagesResponse;
import java.util.Map;

public class SendMediaGroup
extends BaseRequest<SendMediaGroup, MessagesResponse> {
    private boolean isMultipart = false;

    public SendMediaGroup(Object chatId, InputMedia<?> ... media) {
        super(MessagesResponse.class);
        ((SendMediaGroup)this.add("chat_id", chatId)).add("media", media);
        for (InputMedia<?> m : media) {
            Map<String, Object> attachments = m.getAttachments();
            if (attachments != null && attachments.size() > 0) {
                this.addAll(attachments);
                this.isMultipart = true;
            }
            if (m.inputFile() == null) continue;
            this.add(m.getInputFileId(), m.inputFile());
            this.isMultipart = true;
        }
    }

    public SendMediaGroup businessConnectionId(String businessConnectionId2) {
        return (SendMediaGroup)this.add("business_connection_id", businessConnectionId2);
    }

    public SendMediaGroup messageThreadId(Integer messageThreadId2) {
        return (SendMediaGroup)this.add("message_thread_id", messageThreadId2);
    }

    public SendMediaGroup replyParameters(ReplyParameters replyParameters2) {
        return (SendMediaGroup)this.add("reply_parameters", replyParameters2);
    }

    public SendMediaGroup disableNotification(boolean disableNotification2) {
        return (SendMediaGroup)this.add("disable_notification", disableNotification2);
    }

    public SendMediaGroup protectContent(boolean protectContent2) {
        return (SendMediaGroup)this.add("protect_content", protectContent2);
    }

    @Override
    public boolean isMultipart() {
        return this.isMultipart;
    }
}

