/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.request;

import com.pengrad.telegrambot.model.MessageEntity;
import com.pengrad.telegrambot.model.request.ForceReply;
import com.pengrad.telegrambot.model.request.InlineKeyboardMarkup;
import com.pengrad.telegrambot.model.request.InputPaidMedia;
import com.pengrad.telegrambot.model.request.ParseMode;
import com.pengrad.telegrambot.model.request.ReplyKeyboardMarkup;
import com.pengrad.telegrambot.model.request.ReplyKeyboardRemove;
import com.pengrad.telegrambot.model.request.ReplyParameters;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.response.SendResponse;
import java.util.Map;

public class SendPaidMedia
extends BaseRequest<SendPaidMedia, SendResponse> {
    private boolean isMultipart = false;

    public SendPaidMedia(Object chatId, Integer starCount2, InputPaidMedia ... media) {
        super(SendResponse.class);
        ((SendPaidMedia)((SendPaidMedia)this.add("chat_id", chatId)).add("star_count", starCount2)).add("media", media);
        for (InputPaidMedia m : media) {
            Map<String, Object> attachments = m.getAttachments();
            if (attachments != null && !attachments.isEmpty()) {
                this.addAll(attachments);
                this.isMultipart = true;
            }
            if (m.inputFile() == null) continue;
            this.add(m.getInputFileId(), m.inputFile());
            this.isMultipart = true;
        }
    }

    @Override
    public boolean isMultipart() {
        return this.isMultipart;
    }

    public SendPaidMedia caption(String caption2) {
        return (SendPaidMedia)this.add("caption", caption2);
    }

    public SendPaidMedia parseMode(ParseMode parseMode2) {
        return (SendPaidMedia)this.add("parse_mode", parseMode2.name());
    }

    public SendPaidMedia captionEntities(MessageEntity ... entities2) {
        return (SendPaidMedia)this.add("caption_entities", entities2);
    }

    public SendPaidMedia showCaptionAboveMedia(boolean showCaptionAboveMedia2) {
        return (SendPaidMedia)this.add("show_caption_above_media", showCaptionAboveMedia2);
    }

    public SendPaidMedia disableNotification(boolean disableNotification2) {
        return (SendPaidMedia)this.add("disable_notification", disableNotification2);
    }

    public SendPaidMedia protectContent(boolean protectContent2) {
        return (SendPaidMedia)this.add("protect_content", protectContent2);
    }

    public SendPaidMedia replyParameters(ReplyParameters replyParameters2) {
        return (SendPaidMedia)this.add("reply_parameters", replyParameters2);
    }

    public SendPaidMedia businessConnectionId(String businessConnectionId2) {
        return (SendPaidMedia)this.add("business_connection_id", businessConnectionId2);
    }

    public SendPaidMedia replyMarkup(InlineKeyboardMarkup replyMarkup2) {
        return (SendPaidMedia)this.add("reply_markup", replyMarkup2);
    }

    public SendPaidMedia replyMarkup(ReplyKeyboardMarkup replyMarkup2) {
        return (SendPaidMedia)this.add("reply_markup", replyMarkup2);
    }

    public SendPaidMedia replyMarkup(ReplyKeyboardRemove replyMarkup2) {
        return (SendPaidMedia)this.add("reply_markup", replyMarkup2);
    }

    public SendPaidMedia replyMarkup(ForceReply replyMarkup2) {
        return (SendPaidMedia)this.add("reply_markup", replyMarkup2);
    }

    public SendPaidMedia payload(String payload) {
        return (SendPaidMedia)this.add("payload", payload);
    }

    public SendPaidMedia allowPaidBroadcast(boolean allowPaidBroadcast2) {
        return (SendPaidMedia)this.add("allow_paid_broadcast", allowPaidBroadcast2);
    }
}

