/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.model.request;

import com.pengrad.telegrambot.AttachName;
import com.pengrad.telegrambot.model.MessageEntity;
import com.pengrad.telegrambot.model.request.InputFile;
import com.pengrad.telegrambot.model.request.ParseMode;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class InputMedia<T extends InputMedia<T>>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final T thisAsT = this;
    private final String type;
    private final String media;
    private String thumbnail;
    private Boolean show_caption_above_media;
    private String caption;
    private String parse_mode;
    private MessageEntity[] caption_entities;
    private transient Map<String, Object> attachments = new HashMap<String, Object>();
    private transient InputFile inputFile;
    private transient String inputFileAttachId;
    private transient String fileName;
    private transient String contentType;

    InputMedia(String type2, Object media) {
        this.type = type2;
        if (media instanceof String) {
            this.media = (String)media;
        } else {
            String attachName = AttachName.next();
            this.media = "attach://" + attachName;
            this.inputFileAttachId = attachName;
            if (media instanceof File) {
                this.fileName = ((File)media).getName();
                this.inputFile = new InputFile((File)media, this.getFileName(), this.getContentType());
            } else if (media instanceof byte[]) {
                this.inputFile = new InputFile((byte[])media, this.getFileName(), this.getContentType());
            }
        }
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    protected String addAttachment(Object attachment) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, attachment);
        return "attach://" + attachName;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    public String getInputFileId() {
        return this.inputFileAttachId;
    }

    public T showCaptionAboveMedia(Boolean showCaptionAboveMedia2) {
        this.show_caption_above_media = showCaptionAboveMedia2;
        return this.thisAsT;
    }

    public T thumbnail(File thumbnail2) {
        this.thumbnail = this.addAttachment(thumbnail2);
        return this.thisAsT;
    }

    public T thumbnail(byte[] thumbnail2) {
        this.thumbnail = this.addAttachment(thumbnail2);
        return this.thisAsT;
    }

    public T caption(String caption2) {
        this.caption = caption2;
        return this.thisAsT;
    }

    public T parseMode(ParseMode parseMode2) {
        this.parse_mode = parseMode2.name();
        return this.thisAsT;
    }

    public T captionEntities(MessageEntity ... entities2) {
        this.caption_entities = entities2;
        return this.thisAsT;
    }

    public T fileName(String fileName2) {
        if (this.inputFile != null) {
            this.inputFile.setFileName(fileName2);
        }
        this.fileName = fileName2;
        return this.thisAsT;
    }

    public T contentType(String contentType2) {
        if (this.inputFile != null) {
            this.inputFile.setContentType(contentType2);
        }
        this.contentType = contentType2;
        return this.thisAsT;
    }

    public String getFileName() {
        return this.fileName != null && !this.fileName.isEmpty() ? this.fileName : this.getDefaultFileName();
    }

    public String getContentType() {
        return this.contentType != null && !this.contentType.isEmpty() ? this.contentType : this.getDefaultContentType();
    }

    protected abstract String getDefaultFileName();

    protected abstract String getDefaultContentType();
}

