/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.model.request;

import com.pengrad.telegrambot.AttachName;
import com.pengrad.telegrambot.model.request.InputFile;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class InputPaidMedia
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String type;
    private final String media;
    protected transient Map<String, Object> attachments = new HashMap<String, Object>();
    private transient InputFile inputFile;
    private transient String inputFileAttachId;
    private transient String fileName;
    private transient String contentType;

    InputPaidMedia(String type2, Object media) {
        this.type = type2;
        if (media instanceof String) {
            this.media = (String)media;
        } else {
            String attachName = AttachName.next();
            this.media = "attach://" + attachName;
            this.inputFileAttachId = attachName;
            if (media instanceof File) {
                this.fileName = ((File)media).getName();
                this.inputFile = new InputFile((File)media, this.getFileName(), this.getContentType());
            } else if (media instanceof byte[]) {
                this.inputFile = new InputFile((byte[])media, this.getFileName(), this.getContentType());
            }
        }
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    protected String addAttachment(Object attachment) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, attachment);
        return "attach://" + attachName;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    public String getInputFileId() {
        return this.inputFileAttachId;
    }

    public String getFileName() {
        return this.fileName != null && !this.fileName.isEmpty() ? this.fileName : this.getDefaultFileName();
    }

    public String getContentType() {
        return this.contentType != null && !this.contentType.isEmpty() ? this.contentType : this.getDefaultContentType();
    }

    protected abstract String getDefaultFileName();

    protected abstract String getDefaultContentType();
}

