/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.BufferTrigger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SimpleBufferTrigger<E>
implements BufferTrigger<E> {
    private final AtomicLong counter = new AtomicLong();
    private final Consumer<Object> consumer;
    private final BiPredicate<Object, E> queueAdder;
    private final Supplier<Object> bufferFactory;
    private final BiConsumer<Throwable, Object> exceptionHandler;
    private final AtomicReference<Object> buffer = new AtomicReference();
    private volatile boolean running;

    private SimpleBufferTrigger(Supplier<Object> bufferFactory, BiPredicate<Object, E> queueAdder, ScheduledExecutorService scheduledExecutorService, Consumer<Object> consumer, Map<Long, Long> triggerMap, BiConsumer<Throwable, Object> exceptionHandler) {
        this.queueAdder = queueAdder;
        this.bufferFactory = bufferFactory;
        this.consumer = consumer;
        this.exceptionHandler = exceptionHandler;
        for (Map.Entry<Long, Long> entry : triggerMap.entrySet()) {
            scheduledExecutorService.scheduleWithFixedDelay(() -> {
                SimpleBufferTrigger simpleBufferTrigger = this;
                synchronized (simpleBufferTrigger) {
                    if (this.running) {
                        return;
                    }
                    if (this.counter.get() < (Long)entry.getValue()) {
                        return;
                    }
                    this.running = true;
                    Object old = null;
                    try {
                        old = this.buffer.getAndSet(bufferFactory.get());
                        this.counter.set(0L);
                        if (old != null) {
                            consumer.accept(old);
                        }
                    }
                    catch (Throwable e) {
                        if (this.exceptionHandler != null) {
                            try {
                                this.exceptionHandler.accept(e, old);
                            }
                            catch (Throwable throwable) {}
                        } else {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        this.running = false;
                    }
                }
            }, entry.getKey(), entry.getKey(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void enqueue(E element) {
        Object thisBuffer = this.buffer.updateAndGet(old -> old != null ? old : this.bufferFactory.get());
        boolean addSuccess = this.queueAdder.test(thisBuffer, element);
        if (addSuccess) {
            this.counter.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manuallyDoTrigger() {
        SimpleBufferTrigger simpleBufferTrigger = this;
        synchronized (simpleBufferTrigger) {
            this.running = true;
            Object old = null;
            try {
                old = this.buffer.getAndSet(this.bufferFactory.get());
                this.counter.set(0L);
                if (old != null) {
                    this.consumer.accept(old);
                }
            }
            catch (Throwable e) {
                if (this.exceptionHandler != null) {
                    try {
                        this.exceptionHandler.accept(e, old);
                    }
                    catch (Throwable throwable) {}
                } else {
                    e.printStackTrace();
                }
            }
            finally {
                this.running = false;
            }
        }
    }

    public static final <E, C> Builder<E, C> newBuilder() {
        return new Builder();
    }

    public static class Builder<E, C> {
        private ScheduledExecutorService scheduledExecutorService;
        private Supplier<C> bufferFactory;
        private BiPredicate<C, E> queueAdder;
        private Consumer<C> consumer;
        private BiConsumer<Throwable, C> exceptionHandler;
        private final Map<Long, Long> triggerMap = new HashMap<Long, Long>();

        public Builder<E, C> setContainer(Supplier<C> factory, BiPredicate<C, E> queueAdder) {
            if (factory == null || queueAdder == null) {
                throw new IllegalArgumentException();
            }
            this.bufferFactory = factory;
            this.queueAdder = queueAdder;
            return this;
        }

        public Builder<E, C> setScheduleExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder<E, C> setExceptionHandler(BiConsumer<Throwable, C> exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public Builder<E, C> on(long interval, TimeUnit unit, long count) {
            this.triggerMap.put(unit.toMillis(interval), count);
            return this;
        }

        public Builder<E, C> consumer(Consumer<C> consumer) {
            this.consumer = consumer;
            return this;
        }

        public SimpleBufferTrigger<E> build() {
            this.ensure();
            return new SimpleBufferTrigger(this.bufferFactory, this.queueAdder, this.scheduledExecutorService, this.consumer, this.triggerMap, this.exceptionHandler);
        }

        private void ensure() {
            if (this.consumer == null) {
                throw new IllegalArgumentException("there is no consumer defined.");
            }
            if (this.bufferFactory == null) {
                this.bufferFactory = () -> Collections.synchronizedSet(new HashSet());
            }
            if (this.queueAdder == null) {
                this.queueAdder = (c, e) -> ((Set)c).add(e);
            }
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = this.makeScheduleExecutor();
            }
        }

        private ScheduledExecutorService makeScheduleExecutor() {
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
                private final ThreadGroup group;
                private final AtomicInteger threadNumber = new AtomicInteger(1);
                private final String namePrefix;
                {
                    SecurityManager s = System.getSecurityManager();
                    this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                    this.namePrefix = "pool-simple-buffer-trigger-thread-";
                }

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
                    if (t.isDaemon()) {
                        t.setDaemon(false);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            });
            return scheduledExecutorService;
        }
    }
}

