/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.control;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;
import java.io.IOException;
import java.io.InputStream;

public class TroubleCodesCommand
extends ObdCommand {
    protected static final char[] dtcLetters = new char[]{'P', 'C', 'B', 'U'};
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    protected StringBuilder codes = new StringBuilder();

    public TroubleCodesCommand() {
        super("03");
    }

    public TroubleCodesCommand(TroubleCodesCommand other) {
        super(other);
    }

    @Override
    protected void fillBuffer() {
    }

    @Override
    protected void performCalculations() {
        String workingData;
        String result = this.getResult();
        int startIndex = 0;
        if (result.length() % 4 == 0) {
            workingData = this.getResult();
            startIndex = 4;
        } else if (result.contains(":")) {
            workingData = this.getResult().replaceAll("[\r\n].:", "");
            startIndex = 7;
        } else {
            workingData = result.replaceAll("[\r\n]?43", "");
        }
        for (int begin = startIndex; begin < workingData.length(); begin += 4) {
            String dtc = "";
            byte b1 = this.hexStringToByteArray(workingData.charAt(begin));
            int ch1 = (b1 & 0xC0) >> 6;
            int ch2 = (b1 & 0x30) >> 4;
            dtc = dtc + dtcLetters[ch1];
            dtc = dtc + hexArray[ch2];
            if ((dtc = dtc + workingData.substring(begin + 1, begin + 4)).equals("P0000")) {
                return;
            }
            this.codes.append(dtc);
            this.codes.append('\n');
        }
    }

    private byte hexStringToByteArray(char s) {
        return (byte)(Character.digit(s, 16) << 4);
    }

    public String formatResult() {
        return this.codes.toString();
    }

    @Override
    public String getCalculatedResult() {
        return String.valueOf(this.codes);
    }

    @Override
    protected void readRawData(InputStream in) throws IOException {
        char c;
        byte b;
        StringBuilder res = new StringBuilder();
        while ((b = (byte)in.read()) != -1 && (c = (char)b) != '>') {
            if (c == ' ') continue;
            res.append(c);
        }
        this.rawData = res.toString().trim();
    }

    @Override
    public String getFormattedResult() {
        return this.codes.toString();
    }

    @Override
    public String getName() {
        return AvailableCommandNames.TROUBLE_CODES.getValue();
    }
}

