/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.utils;

public abstract class CommandAvailabilityHelper {
    public static int[] digestAvailabilityString(String availabilityString) throws IllegalArgumentException {
        if (availabilityString.length() % 8 != 0) {
            throw new IllegalArgumentException("Invalid length for Availability String supplied: " + availabilityString);
        }
        int[] availabilityArray = new int[availabilityString.length() / 2];
        int i = 0;
        int a = 0;
        while (i < availabilityArray.length) {
            availabilityArray[i] = 16 * CommandAvailabilityHelper.parseHexChar(availabilityString.charAt(a)) + CommandAvailabilityHelper.parseHexChar(availabilityString.charAt(a + 1));
            ++i;
            a += 2;
        }
        return availabilityArray;
    }

    private static int parseHexChar(char hexChar) {
        switch (hexChar) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Invalid character [" + hexChar + "] supplied");
    }

    public static boolean isAvailable(String commandPid, String availabilityString, boolean safetyReturn) {
        return CommandAvailabilityHelper.isAvailable(commandPid, CommandAvailabilityHelper.digestAvailabilityString(availabilityString), safetyReturn);
    }

    public static boolean isAvailable(String commandPid, String availabilityString) throws IllegalArgumentException {
        return CommandAvailabilityHelper.isAvailable(commandPid, CommandAvailabilityHelper.digestAvailabilityString(availabilityString));
    }

    public static boolean isAvailable(String commandPid, int[] availabilityArray, boolean safetyReturn) {
        try {
            return CommandAvailabilityHelper.isAvailable(commandPid, availabilityArray);
        }
        catch (IllegalArgumentException e) {
            return safetyReturn;
        }
    }

    public static boolean isAvailable(String commandPid, int[] availabilityArray) throws IllegalArgumentException {
        int requestedAvailability;
        if (commandPid.equals("00")) {
            return true;
        }
        int cmdNumber = Integer.parseInt(commandPid, 16);
        int arrayIndex = (cmdNumber - 1) / 8;
        if (arrayIndex > availabilityArray.length - 1) {
            throw new IllegalArgumentException("availabilityArray does not contain enough entries to check for command " + commandPid);
        }
        while (cmdNumber > 8) {
            cmdNumber -= 8;
        }
        switch (cmdNumber) {
            case 1: {
                requestedAvailability = 128;
                break;
            }
            case 2: {
                requestedAvailability = 64;
                break;
            }
            case 3: {
                requestedAvailability = 32;
                break;
            }
            case 4: {
                requestedAvailability = 16;
                break;
            }
            case 5: {
                requestedAvailability = 8;
                break;
            }
            case 6: {
                requestedAvailability = 4;
                break;
            }
            case 7: {
                requestedAvailability = 2;
                break;
            }
            case 8: {
                requestedAvailability = 1;
                break;
            }
            default: {
                throw new RuntimeException("This is not supposed to happen.");
            }
        }
        return requestedAvailability == (requestedAvailability & availabilityArray[arrayIndex]);
    }
}

