/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands;

import com.github.pires.obd.commands.control.TroubleCodesObdCommand;
import com.github.pires.obd.commands.protocol.ObdProtocolCommand;
import com.github.pires.obd.exceptions.BusInitException;
import com.github.pires.obd.exceptions.MisunderstoodCommandException;
import com.github.pires.obd.exceptions.NoDataException;
import com.github.pires.obd.exceptions.NonNumericResponseException;
import com.github.pires.obd.exceptions.ObdResponseException;
import com.github.pires.obd.exceptions.StoppedException;
import com.github.pires.obd.exceptions.UnableToConnectException;
import com.github.pires.obd.exceptions.UnknownObdErrorException;
import com.github.pires.obd.exceptions.UnsupportedCommandException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public abstract class ObdCommand {
    protected ArrayList<Integer> buffer = null;
    protected String cmd = null;
    protected boolean useImperialUnits = false;
    protected String rawData = null;
    private final Class[] ERROR_CLASSES = new Class[]{UnableToConnectException.class, BusInitException.class, MisunderstoodCommandException.class, NoDataException.class, StoppedException.class, UnknownObdErrorException.class, UnsupportedCommandException.class};

    public ObdCommand(String command) {
        this.cmd = command;
        this.buffer = new ArrayList();
        if (!(this instanceof ObdProtocolCommand) && !(this instanceof TroubleCodesObdCommand)) {
            this.cmd = this.cmd + " 1";
        }
    }

    private ObdCommand() {
    }

    public ObdCommand(ObdCommand other) {
        this(other.cmd);
    }

    public void run(InputStream in, OutputStream out) throws IOException, InterruptedException {
        this.sendCommand(out);
        this.readResult(in);
    }

    protected void sendCommand(OutputStream out) throws IOException, InterruptedException {
        out.write((this.cmd + "\r").getBytes());
        out.flush();
        Thread.sleep(200L);
    }

    protected void resendCommand(OutputStream out) throws IOException, InterruptedException {
        out.write("\r".getBytes());
        out.flush();
    }

    protected void readResult(InputStream in) throws IOException {
        this.readRawData(in);
        this.checkForErrors();
        this.fillBuffer();
        this.performCalculations();
    }

    protected abstract void performCalculations();

    protected void fillBuffer() {
        this.rawData = this.rawData.replaceAll("\\s", "");
        this.rawData = this.rawData.replaceAll("(BUS INIT)|(BUSINIT)|(\\.)", "");
        if (!this.rawData.matches("([0-9A-F])+")) {
            throw new NonNumericResponseException(this.rawData);
        }
        this.buffer.clear();
        int begin = 0;
        for (int end = 2; end <= this.rawData.length(); end += 2) {
            this.buffer.add(Integer.decode("0x" + this.rawData.substring(begin, end)));
            begin = end;
        }
    }

    protected void readRawData(InputStream in) throws IOException {
        byte b = 0;
        StringBuilder res = new StringBuilder();
        while ((char)(b = (byte)in.read()) != '>') {
            res.append((char)b);
        }
        this.rawData = res.toString().replaceAll("SEARCHING", "");
        this.rawData = this.rawData.replaceAll("\\s", "");
    }

    void checkForErrors() {
        for (Class errorClass : this.ERROR_CLASSES) {
            ObdResponseException messageError;
            try {
                messageError = (ObdResponseException)errorClass.newInstance();
                messageError.setCommand(this.cmd);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (!messageError.isError(this.rawData)) continue;
            throw messageError;
        }
    }

    public String getResult() {
        return this.rawData;
    }

    public abstract String getFormattedResult();

    protected ArrayList<Integer> getBuffer() {
        return this.buffer;
    }

    public boolean useImperialUnits() {
        return this.useImperialUnits;
    }

    public void useImperialUnits(boolean isImperial) {
        this.useImperialUnits = isImperial;
    }

    public abstract String getName();
}

