/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.engine;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;

public class EngineFuelRate
extends ObdCommand {
    private double fuelrate = 0.0;

    public EngineFuelRate() {
        super("01 5E");
    }

    public EngineFuelRate(EngineFuelRate other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        int a = (Integer)this.buffer.get(2);
        int b = (Integer)this.buffer.get(3);
        this.fuelrate = (double)(a * 256 + b) * 0.05;
    }

    @Override
    public String getFormattedResult() {
        return String.format("%.1f%s", this.fuelrate, this.getResultUnit());
    }

    @Override
    public String getCalculatedResult() {
        return String.valueOf(this.fuelrate);
    }

    @Override
    public String getResultUnit() {
        return "L/h";
    }

    public double getVoltage() {
        return this.fuelrate;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.ENGINE_FUEL_RATE.getValue();
    }
}

