/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.exceptions;

public class ObdResponseException
extends RuntimeException {
    private String message;
    private String response;
    private String command;
    private boolean matchRegex;

    protected ObdResponseException(String message) {
        this.message = message;
    }

    protected ObdResponseException(String message, boolean matchRegex) {
        this.message = message;
        this.matchRegex = matchRegex;
    }

    public boolean isError(String response) {
        this.response = response;
        if (this.matchRegex) {
            return ObdResponseException.clean(response).matches(ObdResponseException.clean(this.message));
        }
        return ObdResponseException.clean(response).contains(ObdResponseException.clean(this.message));
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public String getMessage() {
        return "Error running " + this.command + ", response: " + this.response;
    }

    private static String clean(String s) {
        return s == null ? "" : s.replaceAll("\\s", "").toUpperCase();
    }
}

