/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands;

import com.github.pires.obd.exceptions.BusInitException;
import com.github.pires.obd.exceptions.MisunderstoodCommandException;
import com.github.pires.obd.exceptions.NoDataException;
import com.github.pires.obd.exceptions.NonNumericResponseException;
import com.github.pires.obd.exceptions.ResponseException;
import com.github.pires.obd.exceptions.StoppedException;
import com.github.pires.obd.exceptions.UnableToConnectException;
import com.github.pires.obd.exceptions.UnknownErrorException;
import com.github.pires.obd.exceptions.UnsupportedCommandException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public abstract class ObdCommand {
    private final Class[] ERROR_CLASSES = new Class[]{UnableToConnectException.class, BusInitException.class, MisunderstoodCommandException.class, NoDataException.class, StoppedException.class, UnknownErrorException.class, UnsupportedCommandException.class};
    protected ArrayList<Integer> buffer = null;
    protected String cmd = null;
    protected boolean useImperialUnits = false;
    protected String rawData = null;
    protected Long responseDelayInMs = null;
    private long start;
    private long end;

    public ObdCommand(String command) {
        this.cmd = command;
        this.buffer = new ArrayList();
    }

    private ObdCommand() {
    }

    public ObdCommand(ObdCommand other) {
        this(other.cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(InputStream in, OutputStream out) throws IOException, InterruptedException {
        Class<ObdCommand> clazz = ObdCommand.class;
        synchronized (ObdCommand.class) {
            this.start = System.currentTimeMillis();
            this.sendCommand(out);
            this.readResult(in);
            this.end = System.currentTimeMillis();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void sendCommand(OutputStream out) throws IOException, InterruptedException {
        out.write((this.cmd + "\r").getBytes());
        out.flush();
        if (this.responseDelayInMs != null && this.responseDelayInMs > 0L) {
            Thread.sleep(this.responseDelayInMs);
        }
    }

    protected void resendCommand(OutputStream out) throws IOException, InterruptedException {
        out.write("\r".getBytes());
        out.flush();
        if (this.responseDelayInMs != null && this.responseDelayInMs > 0L) {
            Thread.sleep(this.responseDelayInMs);
        }
    }

    protected void readResult(InputStream in) throws IOException {
        this.readRawData(in);
        this.checkForErrors();
        this.fillBuffer();
        this.performCalculations();
    }

    protected abstract void performCalculations();

    protected void fillBuffer() {
        this.rawData = this.rawData.replaceAll("\\s", "");
        this.rawData = this.rawData.replaceAll("(BUS INIT)|(BUSINIT)|(\\.)", "");
        if (!this.rawData.matches("([0-9A-F])+")) {
            throw new NonNumericResponseException(this.rawData);
        }
        this.buffer.clear();
        int begin = 0;
        for (int end = 2; end <= this.rawData.length(); end += 2) {
            this.buffer.add(Integer.decode("0x" + this.rawData.substring(begin, end)));
            begin = end;
        }
    }

    protected void readRawData(InputStream in) throws IOException {
        char c;
        byte b = 0;
        StringBuilder res = new StringBuilder();
        while ((b = (byte)in.read()) > -1 && (c = (char)b) != '>') {
            res.append(c);
        }
        this.rawData = res.toString().replaceAll("SEARCHING", "");
        this.rawData = this.rawData.replaceAll("\\s", "");
    }

    void checkForErrors() {
        for (Class errorClass : this.ERROR_CLASSES) {
            ResponseException messageError;
            try {
                messageError = (ResponseException)errorClass.newInstance();
                messageError.setCommand(this.cmd);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (!messageError.isError(this.rawData)) continue;
            throw messageError;
        }
    }

    public String getResult() {
        return this.rawData;
    }

    public abstract String getFormattedResult();

    public abstract String getCalculatedResult();

    protected ArrayList<Integer> getBuffer() {
        return this.buffer;
    }

    public boolean useImperialUnits() {
        return this.useImperialUnits;
    }

    public String getResultUnit() {
        return "";
    }

    public void useImperialUnits(boolean isImperial) {
        this.useImperialUnits = isImperial;
    }

    public abstract String getName();

    public Long getResponseTimeDelay() {
        return this.responseDelayInMs;
    }

    public void setResponseTimeDelay(Long responseDelayInMs) {
        this.responseDelayInMs = responseDelayInMs;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public final String getCommandPID() {
        return this.cmd.substring(3);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObdCommand that = (ObdCommand)o;
        return this.cmd != null ? this.cmd.equals(that.cmd) : that.cmd == null;
    }

    public int hashCode() {
        return this.cmd != null ? this.cmd.hashCode() : 0;
    }
}

