/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.engine;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;

public class MassAirFlowCommand
extends ObdCommand {
    private float maf = -1.0f;

    public MassAirFlowCommand() {
        super("01 10");
    }

    public MassAirFlowCommand(MassAirFlowCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        this.maf = (float)((Integer)this.buffer.get(2) * 256 + (Integer)this.buffer.get(3)) / 100.0f;
    }

    @Override
    public String getFormattedResult() {
        return String.format("%.2f%s", Float.valueOf(this.maf), this.getResultUnit());
    }

    @Override
    public String getCalculatedResult() {
        return String.valueOf(this.maf);
    }

    @Override
    public String getResultUnit() {
        return "g/s";
    }

    public double getMAF() {
        return this.maf;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.MAF.getValue();
    }
}

