/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.fuel;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;

public class AirFuelRatioCommand
extends ObdCommand {
    private float afr = 0.0f;

    public AirFuelRatioCommand() {
        super("01 44");
    }

    @Override
    protected void performCalculations() {
        float A = ((Integer)this.buffer.get(2)).intValue();
        float B = ((Integer)this.buffer.get(3)).intValue();
        this.afr = (A * 256.0f + B) / 32768.0f * 14.7f;
    }

    @Override
    public String getFormattedResult() {
        return String.format("%.2f", this.getAirFuelRatio()) + ":1 AFR";
    }

    @Override
    public String getCalculatedResult() {
        return String.valueOf(this.getAirFuelRatio());
    }

    public double getAirFuelRatio() {
        return this.afr;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.AIR_FUEL_RATIO.getValue();
    }
}

