/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.mock;

import com.auto.framework.AbstractTestComponent;
import com.auto.framework.TestComponentData;
import com.auto.framework.env.TestEnvironment;
import com.auto.framework.operation.Operation;
import com.auto.framework.operation.OperationFactory;
import com.auto.framework.reporter.TestReporter;
import com.auto.framework.rules.mock.MockConfig;
import com.auto.framework.rules.mock.RequestType;
import com.auto.framework.utils.FileUtil;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import java.io.File;
import java.util.Objects;

public class MockServer
extends AbstractTestComponent {
    private final MockConfig config;
    private WireMockServer wireMockServer;

    public MockServer(TestComponentData data, MockConfig config) {
        super(data);
        this.config = config;
    }

    @Override
    protected Operation getStartOperation() {
        return OperationFactory.consumableOp(() -> {
            this.wireMockServer = new WireMockServer(this.getPort());
            this.wireMockServer.start();
            WireMock.configureFor(this.getHost(), this.wireMockServer.port());
        }, "MockServerStart");
    }

    @Override
    protected Operation getStopOperation() {
        return OperationFactory.consumableOp(() -> this.wireMockServer.shutdownServer(), "MockServerStop");
    }

    @Override
    public boolean isRunning() {
        return Objects.nonNull(this.wireMockServer) && this.wireMockServer.isRunning();
    }

    @Override
    public void prepare() {
        if (Objects.nonNull(this.config)) {
            MappingBuilder mappingBuilder;
            if (RequestType.POST.name().equals(this.config.getType().name())) {
                String req = this.getContentFromFile(this.config.getRequestPath());
                mappingBuilder = WireMock.post(this.config.getUrl()).withRequestBody(WireMock.equalToJson(req));
            } else {
                mappingBuilder = WireMock.get(this.config.getUrl());
            }
            WireMock.stubFor(mappingBuilder.willReturn(this.getResponseDefinitionBuilder()));
        } else {
            TestReporter.FATAL("Can't run Mock server without stub use annotation MockRequestResponse");
        }
    }

    @Override
    public void clean(boolean bForce) {
        this.wireMockServer.resetAll();
    }

    private ResponseDefinitionBuilder getResponseDefinitionBuilder() {
        String res = this.getContentFromFile(this.config.getResponsePath());
        ResponseDefinitionBuilder responseDefinitionBuilder = new ResponseDefinitionBuilder();
        responseDefinitionBuilder.withBody(res).withFixedDelay(this.config.getDelay() * 1000);
        return responseDefinitionBuilder;
    }

    public int callCount() {
        RequestPattern pattern = new RequestPattern(WireMock.urlEqualTo(this.config.getUrl()), RequestMethod.fromString(this.config.getType().name()), null, null, null, null, null, null, null, null);
        return this.wireMockServer.countRequestsMatching(pattern).getCount();
    }

    private String getContentFromFile(String resourcePath) {
        String separator = resourcePath.startsWith("/") ? "" : "/";
        String filePath = TestEnvironment.getResourcePath() + separator + resourcePath;
        return FileUtil.getContents(new File(filePath));
    }
}

